

package space.yizhu.record.template.expr.ast;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;


/**
 * <p>MethodInfo class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class MethodInfo {

    protected final Long key;
    protected final Class<?> clazz;
    protected final Method method;

    protected final boolean isVarArgs;
    protected final Class<?>[] paraTypes;

    /**
     * <p>Constructor for MethodInfo.</p>
     *
     * @param key a {@link java.lang.Long} object.
     * @param clazz a {@link java.lang.Class} object.
     * @param method a {@link java.lang.reflect.Method} object.
     */
    public MethodInfo(Long key, Class<?> clazz, Method method) {
        this.key = key;
        this.clazz = clazz;
        this.method = method;
        this.isVarArgs = method.isVarArgs();
        this.paraTypes = method.getParameterTypes();
    }

    /**
     * <p>invoke.</p>
     *
     * @param target a {@link java.lang.Object} object.
     * @param args a {@link java.lang.Object} object.
     * @return a {@link java.lang.Object} object.
     * @throws java.lang.ReflectiveOperationException if any.
     */
    public Object invoke(Object target, Object... args) throws ReflectiveOperationException {
        if (isVarArgs) {
            return invokeVarArgsMethod(target, args);
        } else {
            return method.invoke(target, args);
        }
    }

    /**
     * <p>invokeVarArgsMethod.</p>
     *
     * @param target a {@link java.lang.Object} object.
     * @param argValues an array of {@link java.lang.Object} objects.
     * @return a {@link java.lang.Object} object.
     * @throws java.lang.ReflectiveOperationException if any.
     */
    protected Object invokeVarArgsMethod(Object target, Object[] argValues) throws ReflectiveOperationException {
        Object[] finalArgValues = new Object[paraTypes.length];

        int fixedParaLength = paraTypes.length - 1;
        System.arraycopy(argValues, 0, finalArgValues, 0, fixedParaLength);
        Class<?> varParaComponentType = paraTypes[paraTypes.length - 1].getComponentType();
        Object varParaValues = Array.newInstance(varParaComponentType, argValues.length - fixedParaLength);
        int p = 0;
        for (int i = fixedParaLength; i < argValues.length; i++) {
            Array.set(varParaValues, p++, argValues[i]);
        }
        finalArgValues[paraTypes.length - 1] = varParaValues;
        return method.invoke(target, finalArgValues);
    }

    /**
     * <p>Getter for the field <code>key</code>.</p>
     *
     * @return a {@link java.lang.Long} object.
     */
    public Long getKey() {
        return key;
    }

    /**
     * <p>getName.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getName() {
        return method.getName();
    }

    /**
     * <p>isStatic.</p>
     *
     * @return a boolean.
     */
    public boolean isStatic() {
        return Modifier.isStatic(method.getModifiers());
    }

    /**
     * <p>isVarArgs.</p>
     *
     * @return a boolean.
     */
    public boolean isVarArgs() {
        return isVarArgs;
    }

    /**
     * <p>getParameterTypes.</p>
     *
     * @return an array of {@link java.lang.Class} objects.
     */
    protected Class<?>[] getParameterTypes() {
        return paraTypes;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        StringBuilder ret = new StringBuilder(clazz.getName()).append(".").append(method.getName()).append("(");
        for (int i = 0; i < paraTypes.length; i++) {
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(paraTypes[i].getName());
        }
        return ret.append(")").toString();
    }
}


