

package space.yizhu.record.template.expr.ast;

import java.lang.reflect.Method;


/**
 * <p>MethodInfoExt class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class MethodInfoExt extends MethodInfo {

    protected Object objectOfExtensionClass;

    /**
     * <p>Constructor for MethodInfoExt.</p>
     *
     * @param objectOfExtensionClass a {@link java.lang.Object} object.
     * @param key a {@link java.lang.Long} object.
     * @param clazz a {@link java.lang.Class} object.
     * @param method a {@link java.lang.reflect.Method} object.
     */
    public MethodInfoExt(Object objectOfExtensionClass, Long key, Class<?> clazz, Method method) {
        super(key, clazz, method);
        this.objectOfExtensionClass = objectOfExtensionClass;

        
        
        
        
        
    }

    /**
     * <p>invoke.</p>
     *
     * @param target a {@link java.lang.Object} object.
     * @param args a {@link java.lang.Object} object.
     * @return a {@link java.lang.Object} object.
     * @throws java.lang.ReflectiveOperationException if any.
     */
    public Object invoke(Object target, Object... args) throws ReflectiveOperationException {
        Object[] finalArgs = new Object[args.length + 1];
        finalArgs[0] = target;

        if (args.length > 0) {
            System.arraycopy(args, 0, finalArgs, 1, args.length);
        }

        if (isVarArgs) {
            return invokeVarArgsMethod(objectOfExtensionClass, finalArgs);
        } else {
            return method.invoke(objectOfExtensionClass, finalArgs);
        }
    }
}







