

package space.yizhu.record.template.expr.ast;

import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;

import java.lang.reflect.Field;


/**
 * <p>StaticField class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class StaticField extends Expr {

    private Class<?> clazz;
    private String fieldName;
    private Field field;

    /**
     * <p>Constructor for StaticField.</p>
     *
     * @param className a {@link java.lang.String} object.
     * @param fieldName a {@link java.lang.String} object.
     * @param location a {@link space.yizhu.record.template.stat.Location} object.
     */
    public StaticField(String className, String fieldName, Location location) {
        try {
            this.clazz = Class.forName(className);
            this.fieldName = fieldName;
            this.field = clazz.getField(fieldName);
            this.location = location;
        } catch (Exception e) {
            throw new ParseException(e.getMessage(), location, e);
        }
    }

    /** {@inheritDoc} */
    public Object eval(Scope scope) {
        try {
            return field.get(null);
        } catch (Exception e) {
            throw new TemplateException(e.getMessage(), location, e);
        }
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return clazz.getName() + "::" + fieldName;
    }
}







