

package space.yizhu.record.template.ext.extensionmethod;

import space.yizhu.kits.StrKit;


/**
 * <p>StringExt class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class StringExt {

    
    /**
     * <p>toBoolean.</p>
     *
     * @param self a {@link java.lang.String} object.
     * @return a {@link java.lang.Boolean} object.
     */
    public Boolean toBoolean(String self) {
        if (StrKit.isBlank(self)) {
            return null;    
        }

        String value = self.trim().toLowerCase();
        if ("true".equals(value) || "1".equals(value)) {    
            return Boolean.TRUE;
        } else if ("false".equals(value) || "0".equals(value)) {
            return Boolean.FALSE;
        } else {
            throw new RuntimeException("Can not parse to boolean type of value: \"" + self + "\"");
        }
    }

    /**
     * <p>toInt.</p>
     *
     * @param self a {@link java.lang.String} object.
     * @return a {@link java.lang.Integer} object.
     */
    public Integer toInt(String self) {
        return StrKit.isBlank(self) ? null : Integer.parseInt(self);
    }

    /**
     * <p>toLong.</p>
     *
     * @param self a {@link java.lang.String} object.
     * @return a {@link java.lang.Long} object.
     */
    public Long toLong(String self) {
        return StrKit.isBlank(self) ? null : Long.parseLong(self);
    }

    /**
     * <p>toFloat.</p>
     *
     * @param self a {@link java.lang.String} object.
     * @return a {@link java.lang.Float} object.
     */
    public Float toFloat(String self) {
        return StrKit.isBlank(self) ? null : Float.parseFloat(self);
    }

    /**
     * <p>toDouble.</p>
     *
     * @param self a {@link java.lang.String} object.
     * @return a {@link java.lang.Double} object.
     */
    public Double toDouble(String self) {
        return StrKit.isBlank(self) ? null : Double.parseDouble(self);
    }

    /**
     * <p>toShort.</p>
     *
     * @param self a {@link java.lang.String} object.
     * @return a {@link java.lang.Short} object.
     */
    public Short toShort(String self) {
        return StrKit.isBlank(self) ? null : Short.parseShort(self);
    }

    /**
     * <p>toByte.</p>
     *
     * @param self a {@link java.lang.String} object.
     * @return a {@link java.lang.Byte} object.
     */
    public Byte toByte(String self) {
        return StrKit.isBlank(self) ? null : Byte.parseByte(self);
    }
}




