

package space.yizhu.record.template.io;

import java.io.IOException;


/**
 * <p>CharWriter class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class CharWriter extends Writer {

    java.io.Writer out;
    char[] chars;

    /**
     * <p>Constructor for CharWriter.</p>
     *
     * @param bufferSize a int.
     */
    public CharWriter(int bufferSize) {
        this.chars = new char[bufferSize];
    }

    /**
     * <p>init.</p>
     *
     * @param writer a {@link java.io.Writer} object.
     * @return a {@link space.yizhu.record.template.io.CharWriter} object.
     */
    public CharWriter init(java.io.Writer writer) {
        this.out = writer;
        return this;
    }

    /**
     * <p>flush.</p>
     *
     * @throws java.io.IOException if any.
     */
    public void flush() throws IOException {
        out.flush();
    }

    /**
     * <p>close.</p>
     */
    public void close() {
        out = null;
    }

    /** {@inheritDoc} */
    public void write(String str, int offset, int len) throws IOException {
        while (len > chars.length) {
            write(str, offset, chars.length);
            offset += chars.length;
            len -= chars.length;
        }

        str.getChars(offset, offset + len, chars, 0);
        out.write(chars, 0, len);
    }

    /**
     * <p>write.</p>
     *
     * @param str a {@link java.lang.String} object.
     * @throws java.io.IOException if any.
     */
    public void write(String str) throws IOException {
        write(str, 0, str.length());
    }

    /** {@inheritDoc} */
    public void write(StringBuilder stringBuilder, int offset, int len) throws IOException {
        while (len > chars.length) {
            write(stringBuilder, offset, chars.length);
            offset += chars.length;
            len -= chars.length;
        }

        stringBuilder.getChars(offset, offset + len, chars, 0);
        out.write(chars, 0, len);
    }

    /**
     * <p>write.</p>
     *
     * @param stringBuilder a {@link java.lang.StringBuilder} object.
     * @throws java.io.IOException if any.
     */
    public void write(StringBuilder stringBuilder) throws IOException {
        write(stringBuilder, 0, stringBuilder.length());
    }

    /**
     * <p>write.</p>
     *
     * @param writable a {@link space.yizhu.record.template.io.IWritable} object.
     * @throws java.io.IOException if any.
     */
    public void write(IWritable writable) throws IOException {
        char[] data = writable.getChars();
        out.write(data, 0, data.length);
    }

    /**
     * <p>write.</p>
     *
     * @param intValue a int.
     * @throws java.io.IOException if any.
     */
    public void write(int intValue) throws IOException {
        IntegerWriter.write(this, intValue);
    }

    /**
     * <p>write.</p>
     *
     * @param longValue a long.
     * @throws java.io.IOException if any.
     */
    public void write(long longValue) throws IOException {
        LongWriter.write(this, longValue);
    }

    /** {@inheritDoc} */
    public void write(double doubleValue) throws IOException {
        FloatingWriter.write(this, doubleValue);
    }

    /**
     * <p>write.</p>
     *
     * @param floatValue a float.
     * @throws java.io.IOException if any.
     */
    public void write(float floatValue) throws IOException {
        FloatingWriter.write(this, floatValue);
    }

    private static final char[] TRUE_CHARS = "true".toCharArray();
    private static final char[] FALSE_CHARS = "false".toCharArray();

    /**
     * <p>write.</p>
     *
     * @param booleanValue a boolean.
     * @throws java.io.IOException if any.
     */
    public void write(boolean booleanValue) throws IOException {
        out.write(booleanValue ? TRUE_CHARS : FALSE_CHARS);
    }
}






