

package space.yizhu.record.template.io;

import java.io.Writer;


/**
 * <p>FastStringWriter class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class FastStringWriter extends Writer {

    private StringBuilder buf;

    /**
     * <p>Constructor for FastStringWriter.</p>
     */
    public FastStringWriter() {
        buf = new StringBuilder();
    }

    /**
     * <p>Constructor for FastStringWriter.</p>
     *
     * @param initialSize a int.
     */
    public FastStringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        buf = new StringBuilder(initialSize);
    }

    /**
     * <p>write.</p>
     *
     * @param c a int.
     */
    public void write(int c) {
        buf.append((char) c);
    }

    /** {@inheritDoc} */
    public void write(char cbuf[], int off, int len) {
        if ((off < 0) || (off > cbuf.length) || (len < 0) ||
                ((off + len) > cbuf.length) || ((off + len) < 0)) {
            throw new IndexOutOfBoundsException();
        } else if (len == 0) {
            return;
        }
        buf.append(cbuf, off, len);
    }

    /**
     * <p>write.</p>
     *
     * @param str a {@link java.lang.String} object.
     */
    public void write(String str) {
        buf.append(str);
    }

    /** {@inheritDoc} */
    public void write(String str, int off, int len) {
        buf.append(str.substring(off, off + len));
    }

    /** {@inheritDoc} */
    public FastStringWriter append(CharSequence csq) {
        if (csq == null) {
            write("null");
        } else {
            write(csq.toString());
        }
        return this;
    }

    /** {@inheritDoc} */
    public FastStringWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = (csq == null ? "null" : csq);
        write(cs.subSequence(start, end).toString());
        return this;
    }

    /** {@inheritDoc} */
    public FastStringWriter append(char c) {
        write(c);
        return this;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return buf.toString();
    }

    /**
     * <p>getBuffer.</p>
     *
     * @return a {@link java.lang.StringBuilder} object.
     */
    public StringBuilder getBuffer() {
        return buf;
    }

    /**
     * <p>flush.</p>
     */
    public void flush() {

    }

    static int MAX_SIZE = 1024 * 64;

    
    /**
     * <p>close.</p>
     */
    public void close() {
        if (buf.length() > MAX_SIZE) {
            buf = new StringBuilder(MAX_SIZE / 2);    
        } else {
            buf.setLength(0);
        }
    }
}





