

package space.yizhu.record.template.io;

import java.io.IOException;
import java.util.Date;


/**
 * <p>Abstract Writer class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public abstract class Writer {

    protected DateFormats formats = new DateFormats();

    /**
     * <p>flush.</p>
     *
     * @throws java.io.IOException if any.
     */
    public abstract void flush() throws IOException;

    /**
     * <p>close.</p>
     */
    public abstract void close();

    /**
     * <p>write.</p>
     *
     * @param writable a {@link space.yizhu.record.template.io.IWritable} object.
     * @throws java.io.IOException if any.
     */
    public abstract void write(IWritable writable) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param string a {@link java.lang.String} object.
     * @param offset a int.
     * @param length a int.
     * @throws java.io.IOException if any.
     */
    public abstract void write(String string, int offset, int length) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param string a {@link java.lang.String} object.
     * @throws java.io.IOException if any.
     */
    public abstract void write(String string) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param stringBuilder a {@link java.lang.StringBuilder} object.
     * @param offset a int.
     * @param length a int.
     * @throws java.io.IOException if any.
     */
    public abstract void write(StringBuilder stringBuilder, int offset, int length) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param stringBuilder a {@link java.lang.StringBuilder} object.
     * @throws java.io.IOException if any.
     */
    public abstract void write(StringBuilder stringBuilder) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param booleanValue a boolean.
     * @throws java.io.IOException if any.
     */
    public abstract void write(boolean booleanValue) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param intValue a int.
     * @throws java.io.IOException if any.
     */
    public abstract void write(int intValue) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param longValue a long.
     * @throws java.io.IOException if any.
     */
    public abstract void write(long longValue) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param doubleValue a double.
     * @throws java.io.IOException if any.
     */
    public abstract void write(double doubleValue) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param floatValue a float.
     * @throws java.io.IOException if any.
     */
    public abstract void write(float floatValue) throws IOException;

    /**
     * <p>write.</p>
     *
     * @param shortValue a short.
     * @throws java.io.IOException if any.
     */
    public void write(short shortValue) throws IOException {
        write((int) shortValue);
    }

    /**
     * <p>write.</p>
     *
     * @param date a {@link java.util.Date} object.
     * @param datePattern a {@link java.lang.String} object.
     * @throws java.io.IOException if any.
     */
    public void write(Date date, String datePattern) throws IOException {
        String str = formats.getDateFormat(datePattern).format(date);
        write(str, 0, str.length());
    }
}







