

package space.yizhu.record.template.source;

import space.yizhu.kits.HashKit;
import space.yizhu.kits.StrKit;
import space.yizhu.record.template.EngineConfig;


/**
 * <p>StringSource class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class StringSource implements ISource {

    private String cacheKey;
    private StringBuilder content;

    
    /**
     * <p>Constructor for StringSource.</p>
     *
     * @param content a {@link java.lang.String} object.
     * @param cache a boolean.
     */
    public StringSource(String content, boolean cache) {
        if (StrKit.isBlank(content)) {
            throw new IllegalArgumentException("content can not be blank");
        }
        this.content = new StringBuilder(content);
        this.cacheKey = cache ? HashKit.md5(content) : null;    
    }

    /**
     * <p>Constructor for StringSource.</p>
     *
     * @param content a {@link java.lang.StringBuilder} object.
     * @param cache a boolean.
     */
    public StringSource(StringBuilder content, boolean cache) {
        if (content == null || content.length() == 0) {
            throw new IllegalArgumentException("content can not be blank");
        }
        this.content = content;
        this.cacheKey = cache ? HashKit.md5(content.toString()) : null;    
    }

    /**
     * <p>isModified.</p>
     *
     * @return a boolean.
     */
    public boolean isModified() {
        return false;
    }

    /**
     * <p>Getter for the field <code>cacheKey</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getCacheKey() {
        return cacheKey;
    }

    /**
     * <p>Getter for the field <code>content</code>.</p>
     *
     * @return a {@link java.lang.StringBuilder} object.
     */
    public StringBuilder getContent() {
        return content;
    }

    /**
     * <p>getEncoding.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getEncoding() {
        return EngineConfig.DEFAULT_ENCODING;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("cacheKey : ").append(cacheKey).append("\n");
        sb.append("content : ").append(content).append("\n");
        return sb.toString();
    }
}







