

package space.yizhu.record.template.stat;


/**
 * <p>CharTable class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class CharTable {

    private static final char[] letterChars = buildLetterChars();
    private static final char[] letterOrDigitChars = buildLetterOrDigitChars();
    private static final char[] exprChars = buildExprChars();
    private static final char NULL = 0;
    private static final char SIZE = 128;

    private CharTable() {
    }

    private static char[] createCharArray() {
        char[] ret = new char[SIZE];
        for (char i = 0; i < SIZE; i++) {
            ret[i] = NULL;
        }
        return ret;
    }

    private static char[] buildLetterChars() {
        char[] ret = createCharArray();
        for (char i = 'a'; i <= 'z'; i++) {
            ret[i] = i;
        }
        for (char i = 'A'; i <= 'Z'; i++) {
            ret[i] = i;
        }
        ret['_'] = '_';            
        return ret;
    }

    private static char[] buildLetterOrDigitChars() {
        char[] ret = buildLetterChars();
        for (char i = '0'; i <= '9'; i++) {
            ret[i] = i;
        }
        return ret;
    }

    private static char[] buildExprChars() {
        char[] ret = createCharArray();
        ret['\t'] = '\t';
        ret['\n'] = '\n';
        ret['\r'] = '\r';
        for (char i = ' '; i <= '}'; i++) {
            ret[i] = i;
        }

        ret['#'] = NULL;
        ret['$'] = NULL;
        ret['@'] = NULL;
        ret['\\'] = NULL;
        ret['^'] = NULL;
        ret['`'] = NULL;
        return ret;
    }

    /**
     * <p>isLetter.</p>
     *
     * @param c a char.
     * @return a boolean.
     */
    public static boolean isLetter(char c) {
        return c < SIZE && letterChars[c] != NULL;
    }

    /**
     * <p>isLetterOrDigit.</p>
     *
     * @param c a char.
     * @return a boolean.
     */
    public static boolean isLetterOrDigit(char c) {
        return c < SIZE && letterOrDigitChars[c] != NULL;
    }

    /**
     * <p>isExprChar.</p>
     *
     * @param c a char.
     * @return a boolean.
     */
    public static boolean isExprChar(char c) {
        return c < SIZE && exprChars[c] != NULL;
    }

    /**
     * <p>isDigit.</p>
     *
     * @param c a char.
     * @return a boolean.
     */
    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    /**
     * <p>isBlank.</p>
     *
     * @param c a char.
     * @return a boolean.
     */
    public static boolean isBlank(char c) {
        return c == ' ' || c == '\t';                                
    }

    /**
     * <p>isBlankOrLineFeed.</p>
     *
     * @param c a char.
     * @return a boolean.
     */
    public static boolean isBlankOrLineFeed(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';        
    }

    /**
     * <p>isHexadecimalDigit.</p>
     *
     * @param c a char.
     * @return a boolean.
     */
    public static boolean isHexadecimalDigit(char c) {
        return (c >= '0' && c <= '9') || (c >= 'A' && c <= 'F') || (c >= 'a' && c <= 'f');
    }

    /**
     * <p>isOctalDigit.</p>
     *
     * @param c a char.
     * @return a boolean.
     */
    public static boolean isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }
}




