

package space.yizhu.record.template.stat;


/**
 * <p>Ctrl class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class Ctrl {

    private static final int JUMP_NONE = 0;
    private static final int JUMP_BREAK = 1;
    private static final int JUMP_CONTINUE = 2;
    private static final int JUMP_RETURN = 3;

    private static final int WISDOM_ASSIGNMENT = 0;
    private static final int LOCAL_ASSIGNMENT = 1;
    private static final int GLOBAL_ASSIGNMENT = 2;

    private int jump = JUMP_NONE;
    private int assignmentType = WISDOM_ASSIGNMENT;
    private boolean nullSafe = false;

    /**
     * <p>isJump.</p>
     *
     * @return a boolean.
     */
    public boolean isJump() {
        return jump != JUMP_NONE;
    }

    /**
     * <p>notJump.</p>
     *
     * @return a boolean.
     */
    public boolean notJump() {
        return jump == JUMP_NONE;
    }

    /**
     * <p>isBreak.</p>
     *
     * @return a boolean.
     */
    public boolean isBreak() {
        return jump == JUMP_BREAK;
    }

    /**
     * <p>setBreak.</p>
     */
    public void setBreak() {
        jump = JUMP_BREAK;
    }

    /**
     * <p>isContinue.</p>
     *
     * @return a boolean.
     */
    public boolean isContinue() {
        return jump == JUMP_CONTINUE;
    }

    /**
     * <p>setContinue.</p>
     */
    public void setContinue() {
        jump = JUMP_CONTINUE;
    }

    /**
     * <p>isReturn.</p>
     *
     * @return a boolean.
     */
    public boolean isReturn() {
        return jump == JUMP_RETURN;
    }

    /**
     * <p>setReturn.</p>
     */
    public void setReturn() {
        jump = JUMP_RETURN;
    }

    /**
     * <p>setJumpNone.</p>
     */
    public void setJumpNone() {
        jump = JUMP_NONE;
    }

    /**
     * <p>isWisdomAssignment.</p>
     *
     * @return a boolean.
     */
    public boolean isWisdomAssignment() {
        return assignmentType == WISDOM_ASSIGNMENT;
    }

    /**
     * <p>setWisdomAssignment.</p>
     */
    public void setWisdomAssignment() {
        assignmentType = WISDOM_ASSIGNMENT;
    }

    /**
     * <p>isLocalAssignment.</p>
     *
     * @return a boolean.
     */
    public boolean isLocalAssignment() {
        return assignmentType == LOCAL_ASSIGNMENT;
    }

    /**
     * <p>setLocalAssignment.</p>
     */
    public void setLocalAssignment() {
        assignmentType = LOCAL_ASSIGNMENT;
    }

    /**
     * <p>isGlobalAssignment.</p>
     *
     * @return a boolean.
     */
    public boolean isGlobalAssignment() {
        return assignmentType == GLOBAL_ASSIGNMENT;
    }

    /**
     * <p>setGlobalAssignment.</p>
     */
    public void setGlobalAssignment() {
        assignmentType = GLOBAL_ASSIGNMENT;
    }

    /**
     * <p>isNullSafe.</p>
     *
     * @return a boolean.
     */
    public boolean isNullSafe() {
        return nullSafe;
    }

    /**
     * <p>notNullSafe.</p>
     *
     * @return a boolean.
     */
    public boolean notNullSafe() {
        return !nullSafe;
    }

    /**
     * <p>Setter for the field <code>nullSafe</code>.</p>
     *
     * @param nullSafe a boolean.
     */
    public void setNullSafe(boolean nullSafe) {
        this.nullSafe = nullSafe;
    }
}






