

package space.yizhu.record.template.stat;


/**
 * <p>Location class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class Location {

    private String templateFile;
    private int row;
    private String msg;

    /**
     * <p>Constructor for Location.</p>
     *
     * @param templateFile a {@link java.lang.String} object.
     * @param row a int.
     */
    public Location(String templateFile, int row) {
        this.templateFile = templateFile;
        this.row = row;
        this.msg = null;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        if (msg == null) {
            StringBuilder buf = new StringBuilder();
            if (templateFile != null) {
                buf.append("\nTemplate: \"").append(templateFile).append("\". Line: ").append(row);
            } else {
                buf.append("\nString template line: ").append(row);
            }
            msg = buf.toString();
        }
        return msg;
    }

    /**
     * <p>Getter for the field <code>templateFile</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getTemplateFile() {
        return templateFile;
    }

    /**
     * <p>Getter for the field <code>row</code>.</p>
     *
     * @return a int.
     */
    public int getRow() {
        return row;
    }
}






