

package space.yizhu.record.template.stat;


/**
 * <p>ParaToken class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class ParaToken extends Token {

    
    private StringBuilder content;

    /**
     * <p>Constructor for ParaToken.</p>
     *
     * @param content a {@link java.lang.StringBuilder} object.
     * @param row a int.
     */
    public ParaToken(StringBuilder content, int row) {
        super(Symbol.PARA, row);
        this.content = content;
    }

    /**
     * <p>value.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String value() {
        return content.toString();
    }

    /**
     * <p>Getter for the field <code>content</code>.</p>
     *
     * @return a {@link java.lang.StringBuilder} object.
     */
    public StringBuilder getContent() {
        return content;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return content != null ? content.toString() : "null";
    }

    /**
     * <p>print.</p>
     */
    public void print() {
        System.out.print("[");
        System.out.print(row);
        System.out.print(", PARA, ");
        System.out.print(toString());
        System.out.println("]");
    }
}

