

package space.yizhu.record.template.stat;

import java.util.HashMap;
import java.util.Map;


/**
 * <p>Scope class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
@SuppressWarnings({"rawtypes", "unchecked"})
public class Scope {

    private final Scope parent;
    private final Ctrl ctrl;
    private Map data;
    private Map<String, Object> sharedObjectMap;

    
    /**
     * <p>Constructor for Scope.</p>
     *
     * @param data a {@link java.util.Map} object.
     * @param sharedObjectMap a {@link java.util.Map} object.
     */
    public Scope(Map data, Map<String, Object> sharedObjectMap) {
        this.parent = null;
        this.ctrl = new Ctrl();
        this.data = data;
        this.sharedObjectMap = sharedObjectMap;
    }

    
    /**
     * <p>Constructor for Scope.</p>
     *
     * @param parent a {@link space.yizhu.record.template.stat.Scope} object.
     */
    public Scope(Scope parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent can not be null.");
        }
        this.parent = parent;
        this.ctrl = parent.ctrl;
        this.data = null;
        this.sharedObjectMap = parent.sharedObjectMap;
    }

    /**
     * <p>Getter for the field <code>ctrl</code>.</p>
     *
     * @return a {@link space.yizhu.record.template.stat.Ctrl} object.
     */
    public Ctrl getCtrl() {
        return ctrl;
    }

    
    /**
     * <p>set.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.Object} object.
     */
    public void set(Object key, Object value) {
        for (Scope cur = this; true; cur = cur.parent) {
            
            if (cur.data != null && cur.data.containsKey(key)) {
                cur.data.put(key, value);
                return;
            }

            if (cur.parent == null) {
                if (cur.data == null) {            
                    cur.data = new HashMap();
                }
                cur.data.put(key, value);
                return;
            }
        }
    }

    
    /**
     * <p>get.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link java.lang.Object} object.
     */
    public Object get(Object key) {
        for (Scope cur = this; cur != null; cur = cur.parent) {




            if (cur.data != null) {
                Object ret = cur.data.get(key);
                if (ret != null) {
                    return ret;
                }

                if (cur.data.containsKey(key)) {
                    return null;
                }
            }
        }
        
        return sharedObjectMap != null ? sharedObjectMap.get(key) : null;
    }

    
    /**
     * <p>remove.</p>
     *
     * @param key a {@link java.lang.Object} object.
     */
    public void remove(Object key) {
        for (Scope cur = this; cur != null; cur = cur.parent) {
            if (cur.data != null && cur.data.containsKey(key)) {
                cur.data.remove(key);
                return;
            }
        }
    }

    
    /**
     * <p>setLocal.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.Object} object.
     */
    public void setLocal(Object key, Object value) {
        if (data == null) {
            data = new HashMap();
        }
        data.put(key, value);
    }

    
    /**
     * <p>getLocal.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link java.lang.Object} object.
     */
    public Object getLocal(Object key) {
        return data != null ? data.get(key) : null;
    }

    
    /**
     * <p>removeLocal.</p>
     *
     * @param key a {@link java.lang.Object} object.
     */
    public void removeLocal(Object key) {
        if (data != null) {
            data.remove(key);
        }
    }

    
    /**
     * <p>setGlobal.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.Object} object.
     */
    public void setGlobal(Object key, Object value) {
        for (Scope cur = this; true; cur = cur.parent) {
            if (cur.parent == null) {
                cur.data.put(key, value);
                return;
            }
        }
    }

    
    /**
     * <p>getGlobal.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link java.lang.Object} object.
     */
    public Object getGlobal(Object key) {
        for (Scope cur = this; true; cur = cur.parent) {
            if (cur.parent == null) {
                return cur.data.get(key);
            }
        }
    }

    
    /**
     * <p>removeGlobal.</p>
     *
     * @param key a {@link java.lang.Object} object.
     */
    public void removeGlobal(Object key) {
        for (Scope cur = this; true; cur = cur.parent) {
            if (cur.parent == null) {
                cur.data.remove(key);
                return;
            }
        }
    }

    
    /**
     * <p>getMapOfValue.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link java.util.Map} object.
     */
    public Map getMapOfValue(Object key) {
        for (Scope cur = this; cur != null; cur = cur.parent) {
            if (cur.data != null && cur.data.containsKey(key)) {
                return cur.data;
            }
        }
        return null;
    }

    
    /**
     * <p>Getter for the field <code>data</code>.</p>
     *
     * @return a {@link java.util.Map} object.
     */
    public Map getData() {
        return data;
    }

    
    /**
     * <p>Setter for the field <code>data</code>.</p>
     *
     * @param data a {@link java.util.Map} object.
     */
    public void setData(Map data) {
        this.data = data;
    }

    
    /**
     * <p>getRootData.</p>
     *
     * @return a {@link java.util.Map} object.
     */
    public Map getRootData() {
        for (Scope cur = this; true; cur = cur.parent) {
            if (cur.parent == null) {
                return cur.data;
            }
        }
    }

    
    /**
     * <p>setRootData.</p>
     *
     * @param data a {@link java.util.Map} object.
     */
    public void setRootData(Map data) {
        for (Scope cur = this; true; cur = cur.parent) {
            if (cur.parent == null) {
                cur.data = data;
                return;
            }
        }
    }

    
    /**
     * <p>exists.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a boolean.
     */
    public boolean exists(Object key) {
        for (Scope cur = this; cur != null; cur = cur.parent) {
            if (cur.data != null && cur.data.containsKey(key)) {
                return true;
            }
        }
        return false;
    }
}



