

package space.yizhu.record.template.stat;


class TextToken extends Token {

    
    private StringBuilder text;

    /**
     * <p>Constructor for TextToken.</p>
     *
     * @param value a {@link java.lang.StringBuilder} object.
     * @param row a int.
     */
    public TextToken(StringBuilder value, int row) {
        super(Symbol.TEXT, row);
        this.text = value;
    }

    /**
     * <p>append.</p>
     *
     * @param content a {@link java.lang.StringBuilder} object.
     */
    public void append(StringBuilder content) {
        if (content != null) {
            text.append(content);    
        }
    }

    
    /**
     * <p>deleteBlankTails.</p>
     *
     * @return a boolean.
     */
    public boolean deleteBlankTails() {
        for (int i = text.length() - 1; i >= 0; i--) {
            if (CharTable.isBlank(text.charAt(i))) {
                continue;
            }

            if (text.charAt(i) == '\n') {
                text.delete(i + 1, text.length());
                return true;
            } else {
                return false;
            }
        }

        
        text.setLength(0);
        return true;        
    }

    /**
     * <p>value.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String value() {
        return text.toString();
    }

    /**
     * <p>getContent.</p>
     *
     * @return a {@link java.lang.StringBuilder} object.
     */
    public StringBuilder getContent() {
        return text;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return text.toString();
    }

    /**
     * <p>print.</p>
     */
    public void print() {
        System.out.print("[");
        System.out.print(row);
        System.out.print(", TEXT, ");
        System.out.print(text.toString());
        System.out.println("]");
    }
}


