

package space.yizhu.record.template.stat;


class Token {

    final Symbol symbol;
    final int row;
    private final String value;

    Token(Symbol symbol, String value, int row) {
        if (symbol == null || value == null) {
            throw new IllegalArgumentException("symbol and value can not be null");
        }
        this.symbol = symbol;
        this.value = value;
        this.row = row;
    }

    Token(Symbol symbol, int row) {
        this(symbol, symbol.getName(), row);
    }

    boolean hasPara() {
        return symbol.hasPara();
    }

    boolean noPara() {
        return symbol.noPara();
    }

    /**
     * <p>value.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String value() {
        return value;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return value;
    }

    /**
     * <p>Getter for the field <code>row</code>.</p>
     *
     * @return a int.
     */
    public int getRow() {
        return row;
    }

    /**
     * <p>print.</p>
     */
    public void print() {
        System.out.print("[");
        System.out.print(row);
        System.out.print(", ");
        System.out.print(symbol.getName());
        System.out.print(", ");
        System.out.print(value());
        System.out.println("]");
    }
}


