

package space.yizhu.record.template.stat.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NoSuchElementException;

import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.stat.Location;


/**
 * <p>ForIteratorStatus class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class ForIteratorStatus {

    private Object outer;
    private int index;
    private int size;
    private Iterator<?> iterator;
    private Location location;

    /**
     * <p>Constructor for ForIteratorStatus.</p>
     *
     * @param outer a {@link java.lang.Object} object.
     * @param target a {@link java.lang.Object} object.
     * @param location a {@link space.yizhu.record.template.stat.Location} object.
     */
    public ForIteratorStatus(Object outer, Object target, Location location) {
        this.outer = outer;
        this.index = 0;
        this.location = location;
        init(target);
    }

    @SuppressWarnings("unchecked")
    private void init(Object target) {
        if (target instanceof Collection) {
            size = ((Collection<?>) target).size();
            iterator = ((Collection<?>) target).iterator();
            return;
        }
        if (target instanceof Map<?, ?>) {
            size = ((Map<?, ?>) target).size();
            iterator = new MapIterator(((Map<Object, Object>) target).entrySet().iterator());
            return;
        }
        if (target == null) {    
            size = 0;
            iterator = NullIterator.me;
            return;
        }
        if (target.getClass().isArray()) {
            size = Array.getLength(target);
            iterator = new ArrayIterator(target, size);
            return;
        }
        if (target instanceof Iterator) {
            size = -1;
            iterator = (Iterator<?>) target;
            return;
        }
        if (target instanceof Iterable) {
            size = -1;
            iterator = ((Iterable<?>) target).iterator();
            return;
        }
        if (target instanceof Enumeration) {
            ArrayList<?> list = Collections.list((Enumeration<?>) target);
            size = list.size();
            iterator = list.iterator();
            return;
        }

        size = 1;
        iterator = new SingleObjectIterator(target);
    }

    Iterator<?> getIterator() {
        return iterator;
    }

    void nextState() {
        index++;
    }

    /**
     * <p>Getter for the field <code>outer</code>.</p>
     *
     * @return a {@link java.lang.Object} object.
     */
    public Object getOuter() {
        return outer;
    }

    /**
     * <p>Getter for the field <code>index</code>.</p>
     *
     * @return a int.
     */
    public int getIndex() {
        return index;
    }

    /**
     * <p>getCount.</p>
     *
     * @return a int.
     */
    public int getCount() {
        return index + 1;
    }

    /**
     /**
      * <p>Constructor for MapIterator.</p>
      *
      * @param iterator a {@link java.util.Iterator} object.
     * <p>Getter for the field <code>size</code>.</p>
     *
     * @return a int.
     */
    /**
     * <p>hasNext.</p>
     *
     * @return a boolean.
     * @return a boolean.
     */
    public int getSize() {
        if (size >= 0) {
            return size;
        }
        /**
         * <p>next.</p>
         *
         * @return a {@link java.util.Map.Entry} object.
         */
        throw new TemplateException("No such method getSize() of the iterator", location);
    }

    /**
     * <p>getFirst.</p>
     /**
      * <p>remove.</p>
    /**
     * <p>hasNext.</p>
     *
     * @return a boolean.
     */
    public boolean getFirst() {
        return index == 0;
    }

    /**
     * <p>Constructor for SingleObjectIterator.</p>
     *
     * @param target a {@link java.lang.Object} object.
     */
    /**
     * <p>remove.</p>
     */
    /**
     /**
      * <p>hasNext.</p>
      *
      * @return a boolean.
     * <p>getLast.</p>
     *
     * @return a boolean.
     */
    /**
     * <p>next.</p>
     *
     * @return a {@link java.lang.Object} object.
     * @return a {@link java.lang.Object} object.
     * @return a {@link java.lang.Object} object.
     */
    public boolean getLast() {
        return !iterator.hasNext();
    }

    /**
    /**
     * <p>hasNext.</p>
     *
     * @return a {@link java.lang.Object} object.
     * <p>remove.</p>
     * @return a {@link java.lang.Object} object.
     * <p>remove.</p>
     * @return a {@link java.lang.Object} object.
     * <p>remove.</p>
     */
    public boolean getOdd() {
        /**
         * <p>remove.</p>
         */
        return index % 2 == 0;
    }

    /**
     * <p>getEven.</p>
     *
     * @return a boolean.
     */
    public boolean getEven() {
        return index % 2 != 0;
    }
}

class MapIterator implements Iterator<Entry<Object, Object>> {

    private Iterator<Entry<Object, Object>> iterator;
    private ForEntry forEntry = new ForEntry();
/**
 * <p>Constructor for MapIterator.</p>
 *
 * @param iterator a {@link java.util.Iterator} object.
 */

    public MapIterator(Iterator<Entry<Object, Object>> iterator) {
        this.iterator = iterator;
    }
/**
 * <p>hasNext.</p>
 *
 * @return a boolean.
 */

    @Override
    public boolean hasNext() {
        return iterator.hasNext();
    }
/**
 * <p>next.</p>
 *
 * @return a {@link java.util.Map.Entry} object.
 */

    @Override
    public Entry<Object, Object> next() {
        forEntry.init(iterator.next());
        return forEntry;
    }
/**
 * <p>remove.</p>
 /**
  * <p>hasNext.</p>
  *
  * @return a boolean.
 */

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    /**
     * <p>next.</p>
     *
     * @return a {@link java.lang.Object} object.
     */
    }
}

class ArrayIterator implements Iterator<Object> {
/**
 * <p>Constructor for SingleObjectIterator.</p>
 *
 * @param target a {@link java.lang.Object} object.
 */
/**
 * <p>remove.</p>
 */

    /**
     * <p>hasNext.</p>
     *
     * @return a boolean.
     */
    private Object array;
    private int size;
    private int index;

    /**
     * <p>next.</p>
     *
     * @return a {@link java.lang.Object} object.
     */
    ArrayIterator(Object array, int size) {
        this.array = array;
        this.size = size;
        this.index = 0;
    }
/**
 * <p>hasNext.</p>
 *
 * @return a boolean.
 */

    @Override
    public boolean hasNext() {
        return index < size;
    /**
     /**
      * <p>next.</p>
      *
      * @return a {@link java.lang.Object} object.
     * <p>remove.</p>
     */
    }

    /**
     * <p>remove.</p>
     */
    @Override
    public Object next() {
        return Array.get(array, index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

class SingleObjectIterator implements Iterator<Object> {

    private Object target;
    private boolean hasNext = true;

    public SingleObjectIterator(Object target) {
        this.target = target;
    }

    @Override
    public boolean hasNext() {
        return hasNext;
    }

    @Override
    public Object next() {
        if (hasNext) {
            hasNext = false;
            return target;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

class NullIterator implements Iterator<Object> {

    static final Iterator<?> me = new NullIterator();

    private NullIterator() {
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public Object next() {
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}






