

package space.yizhu.record.template.stat.ast;


/**
 * <p>ForLoopStatus class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class ForLoopStatus {

    private Object outer;
    private int index;

    /**
     * <p>Constructor for ForLoopStatus.</p>
     *
     * @param outer a {@link java.lang.Object} object.
     */
    public ForLoopStatus(Object outer) {
        this.outer = outer;
        this.index = 0;
    }

    void nextState() {
        index++;
    }

    /**
     * <p>Getter for the field <code>outer</code>.</p>
     *
     * @return a {@link java.lang.Object} object.
     */
    public Object getOuter() {
        return outer;
    }

    /**
     * <p>Getter for the field <code>index</code>.</p>
     *
     * @return a int.
     */
    public int getIndex() {
        return index;
    }

    /**
     * <p>getCount.</p>
     *
     * @return a int.
     */
    public int getCount() {
        return index + 1;
    }

    /**
     * <p>getFirst.</p>
     *
     * @return a boolean.
     */
    public boolean getFirst() {
        return index == 0;
    }

    /**
     * <p>getOdd.</p>
     *
     * @return a boolean.
     */
    public boolean getOdd() {
        return index % 2 == 0;
    }

    /**
     * <p>getEven.</p>
     *
     * @return a boolean.
     */
    public boolean getEven() {
        return index % 2 != 0;
    }
}



