

package space.yizhu.record.template.stat.ast;

import java.io.IOException;

import space.yizhu.record.template.Env;
import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.Scope;


/**
 * <p>Abstract Stat class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public abstract class Stat {

    protected Location location;

    /**
     * <p>Setter for the field <code>location</code>.</p>
     *
     * @param location a {@link space.yizhu.record.template.stat.Location} object.
     * @return a {@link space.yizhu.record.template.stat.ast.Stat} object.
     */
    public Stat setLocation(Location location) {
        this.location = location;
        return this;
    }

    /**
     * <p>Getter for the field <code>location</code>.</p>
     *
     * @return a {@link space.yizhu.record.template.stat.Location} object.
     */
    public Location getLocation() {
        return location;
    }

    /**
     * <p>setExprList.</p>
     *
     * @param exprList a {@link space.yizhu.record.template.expr.ast.ExprList} object.
     */
    public void setExprList(ExprList exprList) {
    }

    /**
     * <p>setStat.</p>
     *
     * @param stat a {@link space.yizhu.record.template.stat.ast.Stat} object.
     */
    public void setStat(Stat stat) {
    }

    /**
     * <p>exec.</p>
     *
     * @param env a {@link space.yizhu.record.template.Env} object.
     * @param scope a {@link space.yizhu.record.template.stat.Scope} object.
     * @param writer a {@link space.yizhu.record.template.io.Writer} object.
     */
    public abstract void exec(Env env, Scope scope, Writer writer);

    /**
     * <p>hasEnd.</p>
     *
     * @return a boolean.
     */
    public boolean hasEnd() {
        return false;
    }

    /**
     * <p>write.</p>
     *
     * @param writer a {@link space.yizhu.record.template.io.Writer} object.
     * @param str a {@link java.lang.String} object.
     */
    protected void write(Writer writer, String str) {
        try {
            writer.write(str, 0, str.length());
        } catch (IOException e) {
            throw new TemplateException(e.getMessage(), location, e);
        }
    }
}


