

package space.yizhu.record.template.stat.ast;

import space.yizhu.record.template.Env;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;


/**
 * <p>Switch class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class Switch extends Stat implements CaseSetter {

    private Expr expr;
    private Case nextCase;
    private Default _default;

    /**
     * <p>Constructor for Switch.</p>
     *
     * @param exprList a {@link space.yizhu.record.template.expr.ast.ExprList} object.
     * @param location a {@link space.yizhu.record.template.stat.Location} object.
     */
    public Switch(ExprList exprList, Location location) {
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #switch directive can not be blank", location);
        }
        this.expr = exprList.getActualExpr();
    }

    /** {@inheritDoc} */
    public void setNextCase(Case nextCase) {
        this.nextCase = nextCase;
    }

    /**
     * <p>setDefault.</p>
     *
     * @param _default a {@link space.yizhu.record.template.stat.ast.Default} object.
     * @param location a {@link space.yizhu.record.template.stat.Location} object.
     */
    public void setDefault(Default _default, Location location) {
        if (this._default != null) {
            throw new ParseException("The #default case of #switch is already defined", location);
        }
        this._default = _default;
    }

    /** {@inheritDoc} */
    public void exec(Env env, Scope scope, Writer writer) {
        Object switchValue = expr.eval(scope);

        if (nextCase != null && nextCase.execIfMatch(switchValue, env, scope, writer)) {
            return;
        }

        if (_default != null) {
            _default.exec(env, scope, writer);
        }
    }

    /**
     * <p>hasEnd.</p>
     *
     * @return a boolean.
     */
    public boolean hasEnd() {
        return true;
    }
}







