/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.bean;

import java.util.List;
import java.util.StringJoiner;
import space.yizhu.bean.BaseModel;
import space.yizhu.kits.ModelKit;
import space.yizhu.kits.ToolKit;
import space.yizhu.record.plugin.activerecord.Page;

public class RetData {
    private boolean succ;
    private int code = 200;
    private String msg;
    private Object data;
    private long pageNum;
    private long pageSize;
    private long totalPage;
    private long totalRow;

    public RetData(Object data) {
        this.succ = data instanceof Boolean ? (Boolean)data : true;
        if (this.succ) {
            this.msg = "\u6267\u884c\u6210\u529f";
        } else {
            this.msg = "\u6267\u884c\u5931\u8d25";
            this.code = -100;
        }
    }

    public RetData() {
        this.succ = true;
        this.msg = "\u6267\u884c\u6210\u529f";
    }

    public RetData(boolean succ) {
        this.succ = succ;
        if (succ) {
            this.msg = "\u6267\u884c\u6210\u529f";
        } else {
            this.msg = "\u6267\u884c\u5931\u8d25";
            this.code = -100;
        }
    }

    public RetData(boolean succ, String msg) {
        this.succ = succ;
        this.msg = msg;
        this.data = msg;
    }

    public RetData(boolean succ, Object data) {
        this.succ = succ;
        if (succ) {
            this.msg = "\u6267\u884c\u6210\u529f";
        } else {
            this.msg = "\u6267\u884c\u5931\u8d25";
            this.code = -100;
        }
        this.data = data;
    }

    public RetData(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public RetData(int code, String msg, Object data) {
        this(code, msg);
        this.data = data;
    }

    public RetData(boolean succ, String msg, Object data) {
        this(succ, msg);
        this.data = data;
    }

    public RetData(int code, String msg, List<Object> datas) {
        this(code, msg);
        this.data = datas;
        this.pageNum = 1L;
        this.pageSize = datas.size();
        this.totalPage = 1L;
        this.totalRow = datas.size();
    }

    public RetData(int code, String msg, Page page) {
        this(code, msg);
        this.pageNum = page.getPageNumber();
        this.pageSize = page.getPageSize();
        this.totalPage = page.getTotalPage();
        this.totalRow = page.getTotalRow();
        this.data = page.getList();
    }

    public RetData(boolean succ, String msg, List<Object> datas) {
        this(succ, msg);
        this.data = datas;
        this.pageNum = 1L;
        this.pageSize = datas.size();
        this.totalPage = 1L;
        this.totalRow = datas.size();
    }

    public RetData(boolean succ, String msg, Page page) {
        this(succ, msg);
        this.pageNum = page.getPageNumber();
        this.pageSize = page.getPageSize();
        this.totalPage = page.getTotalPage();
        this.totalRow = page.getTotalRow();
        this.data = page.getList();
    }

    public RetData setCM(int code, String mesg) {
        this.setCode(code);
        this.setMsg(mesg);
        return this;
    }

    public RetData setCMD(int code, String mesg, Object data) {
        this.setCode(code);
        this.setMsg(mesg);
        this.setData(data);
        return this;
    }

    public RetData setCMD(int code, String mesg, Page page) {
        return this.setCMD(code, mesg, page, false);
    }

    public RetData setCMD(int code, String mesg, Page page, boolean changeToHump) {
        this.setCode(code);
        this.setMsg(mesg);
        this.setPage(page, changeToHump);
        return this;
    }

    public RetData setPage(Page page, boolean changeToHump) {
        if (null != page.getList() && page.getList().size() > 0 && page.getList().get(0) instanceof BaseModel) {
            this.setData(ModelKit.toMaps(page.getList(), changeToHump));
        } else {
            this.setData(page.getList());
        }
        this.pageNum = page.getPageNumber();
        this.pageSize = page.getPageSize();
        this.totalPage = page.getTotalPage();
        this.totalRow = page.getTotalRow();
        return this;
    }

    public boolean isSucc() {
        return this.succ;
    }

    public RetData setSucc(boolean succ) {
        this.succ = succ;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public RetData setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public RetData setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public RetData setData(Object data) {
        this.data = data;
        return this;
    }

    public long getPageNum() {
        return this.pageNum;
    }

    public RetData setPageNum(long pageNum) {
        this.pageNum = pageNum;
        return this;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public RetData setPageSize(long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public RetData setTotalPage(long totalPage) {
        this.totalPage = totalPage;
        return this;
    }

    public long getTotalRow() {
        return this.totalRow;
    }

    public RetData setTotalRow(long totalRow) {
        this.totalRow = totalRow;
        return this;
    }

    public String toString() {
        return new StringJoiner(", ", RetData.class.getSimpleName() + "[", "]").add("succ=" + this.succ).add("code=" + this.code).add("mesg='" + this.msg + "'").add("data=" + ToolKit.toJson(this.data)).add("pageNum=" + this.pageNum).add("pageSize=" + this.pageSize).add("totalPage=" + this.totalPage).add("totalRow=" + this.totalRow).toString();
    }
}

