/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import space.yizhu.kits.SysKit;

public class AddressKit {
    public static double pi = Math.PI;
    public static double x_pi = 52.35987755982988;
    public static double a = 6378245.0;
    public static double ee = 0.006693421622965943;

    public static boolean isIpInRange(String start, String end, String real) {
        if (null == start || null == end || null == real) {
            return false;
        }
        try {
            String[] stIpNums = start.split("\\.");
            String[] edIpNums = end.split("\\.");
            String[] ipNums = real.split("\\.");
            if (stIpNums.length != edIpNums.length || stIpNums.length != ipNums.length) {
                return false;
            }
            int forwordNums = 0;
            boolean backNums = false;
            for (int i = 0; i < stIpNums.length; ++i) {
                int r = Integer.parseInt(ipNums[i]);
                int s = Integer.parseInt(stIpNums[i]);
                int e = Integer.parseInt(edIpNums[i]);
                if (s > 0 ? (r < s || r > e) && forwordNums == 0 : e > 0 && r > e && forwordNums == 0) {
                    return false;
                }
                forwordNums += e > s ? 1 : 0;
            }
            return true;
        }
        catch (NumberFormatException e) {
            SysKit.print(e, "isIpInRange");
            return false;
        }
    }

    public static boolean isSameIp(String large, String small) {
        String[] smalls;
        if (large.equals(small)) {
            return true;
        }
        String[] larges = large.split("\\.");
        if (larges.length != (smalls = small.split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < larges.length; ++i) {
            if (larges[i].equals("0") || larges[i].equals(smalls[i])) continue;
            return false;
        }
        return true;
    }

    public static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * pi) + 40.0 * Math.sin(y / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * pi) + 320.0 * Math.sin(y * pi / 30.0)) * 2.0 / 3.0;
    }

    public static double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * pi) + 40.0 * Math.sin(x / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * pi) + 300.0 * Math.sin(x / 30.0 * pi)) * 2.0 / 3.0;
    }

    public static double[] transform(double lat, double lon) {
        if (AddressKit.outOfChina(lat, lon)) {
            return new double[]{lat, lon};
        }
        double dLat = AddressKit.transformLat(lon - 105.0, lat - 35.0);
        double dLon = AddressKit.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * pi);
        dLon = dLon * 180.0 / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{mgLat, mgLon};
    }

    public static boolean outOfChina(double lat, double lon) {
        if (lon < 72.004 || lon > 137.8347) {
            return true;
        }
        return lat < 0.8293 || lat > 55.8271;
    }

    public static double[] gps84_To_Gcj02(double lat, double lon) {
        if (AddressKit.outOfChina(lat, lon)) {
            return new double[]{lat, lon};
        }
        double dLat = AddressKit.transformLat(lon - 105.0, lat - 35.0);
        double dLon = AddressKit.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * pi);
        dLon = dLon * 180.0 / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{mgLat, mgLon};
    }

    public static double[] gcj02_To_Gps84(double lat, double lon) {
        double[] gps = AddressKit.transform(lat, lon);
        double lontitude = lon * 2.0 - gps[1];
        double latitude = lat * 2.0 - gps[0];
        return new double[]{latitude, lontitude};
    }

    public static double[] gcj02_To_Bd09(double lat, double lon) {
        double x = lon;
        double y = lat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * x_pi);
        double tempLon = z * Math.cos(theta) + 0.0065;
        double tempLat = z * Math.sin(theta) + 0.006;
        double[] gps = new double[]{tempLat, tempLon};
        return gps;
    }

    public static double[] bd09_To_Gcj02(double lat, double lon) {
        double x = lon - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * x_pi);
        double tempLon = z * Math.cos(theta);
        double tempLat = z * Math.sin(theta);
        double[] gps = new double[]{tempLat, tempLon};
        return gps;
    }

    public static double[] gps84_To_bd09(double lat, double lon) {
        double[] gcj02 = AddressKit.gps84_To_Gcj02(lat, lon);
        double[] bd09 = AddressKit.gcj02_To_Bd09(gcj02[0], gcj02[1]);
        return bd09;
    }

    public static double[] bd09_To_gps84(double lat, double lon) {
        double[] gcj02 = AddressKit.bd09_To_Gcj02(lat, lon);
        double[] gps84 = AddressKit.gcj02_To_Gps84(gcj02[0], gcj02[1]);
        gps84[0] = AddressKit.retain6(gps84[0]);
        gps84[1] = AddressKit.retain6(gps84[1]);
        return gps84;
    }

    private static double retain6(double num) {
        String result = String.format("%.6f", num);
        return Double.valueOf(result);
    }

    public static void main(String[] args) {
        SysKit.print(AddressKit.isIpInRange("0.1.7.0", "0.161.0.1", "192.166.1.2") + "");
        SysKit.print(AddressKit.isSameIp("192.0.1.0", "192.168.1.1") + "");
    }
}

