/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import space.yizhu.kits.FileKit;
import space.yizhu.kits.SysKit;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Base64Kit {
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static IBase64 delegate;

    private Base64Kit() {
    }

    public static String encode(byte[] value) {
        return delegate.encode(value);
    }

    public static String encode(String value) {
        byte[] val = value.getBytes(UTF_8);
        return delegate.encode(val);
    }

    public static String encode(String value, String charsetName) {
        byte[] val = value.getBytes(Charset.forName(charsetName));
        return delegate.encode(val);
    }

    public static byte[] decode(String value) {
        return delegate.decode(value);
    }

    public static String decodeToStr(String value) {
        byte[] decodedValue = delegate.decode(value);
        return new String(decodedValue, UTF_8);
    }

    public static String decodeToStr(String value, String charsetName) {
        byte[] decodedValue = delegate.decode(value);
        return new String(decodedValue, Charset.forName(charsetName));
    }

    private static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, true, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static String encodeFile(String path) {
        File file = new File(path);
        try {
            FileInputStream inputFile = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            inputFile.read(buffer);
            inputFile.close();
            return new BASE64Encoder().encode(buffer);
        }
        catch (IOException e) {
            SysKit.print(e);
            return null;
        }
    }

    public static boolean decoder2File(String base64Code, String name, String savePath) {
        if (null == base64Code || base64Code.isEmpty()) {
            return false;
        }
        if (null == savePath || savePath.isEmpty()) {
            savePath = System.getProperty("user.dir");
        }
        base64Code = base64Code.substring(base64Code.indexOf("data:"));
        try {
            String postfix = base64Code.substring(base64Code.indexOf("/"), base64Code.indexOf(";"));
            byte[] buffer = new BASE64Decoder().decodeBuffer(base64Code);
            FileOutputStream out = new FileOutputStream(savePath + "/" + name + "." + postfix);
            out.write(buffer);
            out.close();
            return true;
        }
        catch (IOException e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean decoder2File(String base64Code, String name) {
        if (null == base64Code || base64Code.isEmpty()) {
            return false;
        }
        String savePath = System.getProperty("user.dir");
        try {
            FileOutputStream out;
            byte[] buffer;
            if (base64Code.startsWith("data:")) {
                base64Code = base64Code.substring(base64Code.indexOf("data:"));
                String postfix = base64Code.substring(base64Code.indexOf("/"), base64Code.indexOf(";"));
                buffer = Base64.getDecoder().decode(base64Code);
                out = new FileOutputStream(savePath + "/" + name + "." + postfix);
            } else {
                StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{base64Code});
                if (base64Code.contains("\\n")) {
                    base64Code = base64Code.replaceAll("\\\\n", "");
                }
                buffer = new BASE64Decoder().decodeBuffer(base64Code);
                out = new FileOutputStream(savePath + "/" + name);
            }
            out.write(buffer);
            out.close();
            return true;
        }
        catch (IOException e) {
            SysKit.print(e);
            return false;
        }
    }

    public static void main(String[] args) {
        String base = FileKit.read(new File("D:/work/unicom/tep/base"));
        Base64Kit.decoder2File(base, "\u7535\u5b50\u8bc1\u7167.pdf");
        String data = "";
        try {
            Base64Kit.decoder2File(data, "\u6708\u5bab");
        }
        catch (Exception e) {
            SysKit.print(e);
        }
    }

    static {
        if (Base64Kit.isPresent("java.util.Base64", Base64Kit.class.getClassLoader())) {
            delegate = new Java8Base64();
        }
    }

    static class Java8Base64
    implements IBase64 {
        Java8Base64() {
        }

        @Override
        public String encode(byte[] value) {
            return Base64.getEncoder().encodeToString(value);
        }

        @Override
        public byte[] decode(String value) {
            return Base64.getDecoder().decode(value);
        }
    }

    static interface IBase64 {
        public String encode(byte[] var1);

        public byte[] decode(String var1);
    }
}

