/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import space.yizhu.bean.BaseModel;
import space.yizhu.kits.CharKit;
import space.yizhu.kits.ClassKit;
import space.yizhu.kits.DbKit;
import space.yizhu.kits.SysKit;

public class BeanKit {
    public static ConcurrentHashMap<String, BaseModel<?>> beanMap = new ConcurrentHashMap();

    public static void add(String beanName) {
        if (beanName.length() < 2) {
            return;
        }
        if (CharKit.isSpecialString(beanName, "_")) {
            return;
        }
        String keyName = new String(beanName.getBytes());
        if (beanName.startsWith("_")) {
            beanName = beanName.substring(1);
        }
        if (beanName.startsWith("_")) {
            return;
        }
        try {
            beanMap.put(keyName, ClassKit.createBean(keyName));
        }
        catch (Exception e) {
            SysKit.print(e, "BeanKit-add");
        }
    }

    public static void set(String table_name, BaseModel<?> classT) {
        String keyName = table_name.toLowerCase();
        beanMap.put(keyName, classT);
        try {
            DbKit.addMapping(table_name, classT.getClass());
        }
        catch (Exception e) {
            SysKit.print(e, "beankit.set");
        }
    }

    public static BaseModel<?> get(String beanName) {
        return beanMap.get(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        Output output = null;
        try {
            Kryo kryo = new Kryo();
            baos = new ByteArrayOutputStream();
            output = new Output((OutputStream)baos);
            kryo.writeObject(output, object);
            output.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                SysKit.print(e);
            }
            output.close();
        }
    }

    public static <T> T unserialize(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Kryo kryo = new Kryo();
        Input input = new Input(bytes);
        Object obj = kryo.readObject(input, clazz);
        input.close();
        return (T)obj;
    }

    public static void main(String[] args) {
    }
}

