/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import space.yizhu.bean.BaseModel;
import space.yizhu.kits.BeanKit;
import space.yizhu.kits.SysKit;

public class ClassKit {
    private static Object creatBeanClass(String className, String classContent) throws Exception {
        String fileName = System.getProperty("user.dir") + "/src/main/java/space/yizhu/thing/bean/" + className + ".java";
        File file = new File(fileName);
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(classContent);
        fileWriter.flush();
        fileWriter.close();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager manager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> javaFileObjects = manager.getJavaFileObjects(fileName);
        JavaCompiler.CompilationTask task = compiler.getTask(null, manager, null, null, null, javaFileObjects);
        task.call();
        manager.close();
        URL[] urls = new URL[]{new URL("file:/" + System.getProperty("user.dir") + "/webapps/ROOT/WEB-INF/classes/")};
        URLClassLoader classLoader = new URLClassLoader(urls);
        try {
            Object classObj = classLoader.loadClass("space.yizhu.bean." + className).getConstructors()[0].newInstance(new Object[0]);
            Class<?> classModel = classObj.getClass();
            return classModel.getMethod("getMe", new Class[0]).invoke(classObj, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            SysKit.print(e);
            return null;
        }
    }

    public static Object createClass(String className, String classContent) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(null, null, null);
        ClassJavaFileManager classJavaFileManager = new ClassJavaFileManager(standardFileManager);
        StringObject stringObject = null;
        try {
            stringObject = new StringObject(new URI(className + ".java"), JavaFileObject.Kind.SOURCE, classContent);
        }
        catch (URISyntaxException e) {
            SysKit.print(e);
        }
        JavaCompiler.CompilationTask task = compiler.getTask(null, classJavaFileManager, null, null, null, Arrays.asList(stringObject));
        if (task.call().booleanValue()) {
            ClassJavaFileObject javaFileObject = classJavaFileManager.getClassJavaFileObject();
            MyClassLoader classLoader = new MyClassLoader(javaFileObject);
            try {
                Object classObj = classLoader.loadClass("space.yizhu.bean." + className).getConstructors()[0].newInstance(new Object[0]);
                Class<?> classModel = classObj.getClass();
                return classModel.getMethod("getMe", new Class[0]).invoke(classObj, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                SysKit.print(e);
            }
        }
        return null;
    }

    public static BaseModel<?> createBean(String beanName) throws Exception {
        String topName = beanName.substring(0, 1).toUpperCase();
        beanName = topName + beanName.substring(1);
        String classContent = "package space.yizhu.bean;\nimport space.yizhu.bean.BaseModel;\npublic class " + beanName + " extends BaseModel<" + beanName + "> {\n    public static final " + beanName + " me = new " + beanName + "();\n    public static BaseModel<?> getMe() {\n        return me;\n    }\n}\n";
        BaseModel objClass = (BaseModel)ClassKit.createClass(beanName, classContent);
        BeanKit.set(beanName, objClass);
        return objClass;
    }

    static class MemoryJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        final Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

        MemoryJavaFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        public Map<String, byte[]> getClassBytes() {
            return new HashMap<String, byte[]>(this.classBytes);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            this.classBytes.clear();
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (kind == JavaFileObject.Kind.CLASS) {
                return new MemoryOutputJavaFileObject(className);
            }
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }

        JavaFileObject makeStringSource(String name, String code) {
            return new MemoryInputJavaFileObject(name, code);
        }

        class MemoryOutputJavaFileObject
        extends SimpleJavaFileObject {
            final String name;

            MemoryOutputJavaFileObject(String name) {
                super(URI.create("string:///" + name), JavaFileObject.Kind.CLASS);
                this.name = name;
            }

            @Override
            public OutputStream openOutputStream() {
                return new FilterOutputStream(new ByteArrayOutputStream()){

                    @Override
                    public void close() throws IOException {
                        this.out.close();
                        ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                        MemoryJavaFileManager.this.classBytes.put(MemoryOutputJavaFileObject.this.name, bos.toByteArray());
                    }
                };
            }
        }

        static class MemoryInputJavaFileObject
        extends SimpleJavaFileObject {
            final String code;

            MemoryInputJavaFileObject(String name, String code) {
                super(URI.create("string:///" + name), JavaFileObject.Kind.SOURCE);
                this.code = code;
            }

            @Override
            public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
                return CharBuffer.wrap(this.code);
            }
        }
    }

    static class MemoryClassLoader
    extends URLClassLoader {
        Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

        public MemoryClassLoader(Map<String, byte[]> classBytes) {
            super(new URL[0], MemoryClassLoader.class.getClassLoader());
            this.classBytes.putAll(classBytes);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] buf = this.classBytes.get(name);
            if (buf == null) {
                return super.findClass(name);
            }
            this.classBytes.remove(name);
            return this.defineClass(name, buf, 0, buf.length);
        }
    }

    static class MyClassLoader
    extends ClassLoader {
        private ClassJavaFileObject stringObject;

        public MyClassLoader(ClassJavaFileObject stringObject) {
            this.stringObject = stringObject;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes = this.stringObject.getBytes();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }

    static class ClassJavaFileObject
    extends SimpleJavaFileObject {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        public ClassJavaFileObject(String className, JavaFileObject.Kind kind) {
            super(URI.create(className + kind.extension), kind);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.outputStream;
        }

        public byte[] getBytes() {
            return this.outputStream.toByteArray();
        }
    }

    static class StringObject
    extends SimpleJavaFileObject {
        private String content;

        public StringObject(URI uri, JavaFileObject.Kind kind, String content) {
            super(uri, kind);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.content;
        }
    }

    static class ClassJavaFileManager
    extends ForwardingJavaFileManager {
        private ClassJavaFileObject classJavaFileObject;

        public ClassJavaFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        public ClassJavaFileObject getClassJavaFileObject() {
            return this.classJavaFileObject;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            this.classJavaFileObject = new ClassJavaFileObject(className, kind);
            return this.classJavaFileObject;
        }
    }
}

