/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.yaml.snakeyaml.Yaml;
import space.yizhu.kits.LogKit;

public class ConfigFile {
    protected Properties properties;
    private boolean isYml = false;

    public ConfigFile() {
        this.properties = new Properties();
    }

    public ConfigFile(String fileName) {
        this(fileName, "UTF-8");
    }

    public ConfigFile(String fileName, String encoding) {
        InputStream inputStream = null;
        try {
            inputStream = this.getClassLoader().getResourceAsStream(fileName);
            if (inputStream == null) {
                throw new IllegalArgumentException("Properties file not found in classpath: " + fileName);
            }
            this.properties = new Properties();
            if (fileName.endsWith("yml")) {
                this.isYml = true;
                this.properties = (Properties)new Yaml().loadAs((Reader)new InputStreamReader(inputStream, encoding), Properties.class);
            } else {
                this.properties.load(new InputStreamReader(inputStream, encoding));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : this.getClass().getClassLoader();
    }

    public ConfigFile(File file) {
        this(file, "UTF-8");
    }

    public ConfigFile(File file, String encoding) {
        if (file == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("File not found : " + file.getName());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.properties = new Properties();
            if (file.getName().endsWith("yml")) {
                this.isYml = true;
                this.properties = (Properties)new Yaml().loadAs((Reader)new InputStreamReader((InputStream)inputStream, encoding), Properties.class);
            } else {
                this.properties.load(new InputStreamReader((InputStream)inputStream, encoding));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }

    public ConfigFile append(ConfigFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException("ConfigFile can not be null");
        }
        this.properties.putAll((Map<?, ?>)configFile.getProperties());
        return this;
    }

    public ConfigFile append(String fileName, String encoding) {
        return this.append(new ConfigFile(fileName, encoding));
    }

    public ConfigFile append(String fileName) {
        return this.append(fileName, "UTF-8");
    }

    public ConfigFile appendIfExists(String fileName, String encoding) {
        try {
            return this.append(new ConfigFile(fileName, encoding));
        }
        catch (Exception e) {
            return this;
        }
    }

    public ConfigFile appendIfExists(String fileName) {
        return this.appendIfExists(fileName, "UTF-8");
    }

    public ConfigFile append(File file, String encoding) {
        return this.append(new ConfigFile(file, encoding));
    }

    public ConfigFile append(File file) {
        return this.append(file, "UTF-8");
    }

    public ConfigFile appendIfExists(File file, String encoding) {
        if (file.isFile()) {
            this.append(new ConfigFile(file, encoding));
        }
        return this;
    }

    public ConfigFile appendIfExists(File file) {
        return this.appendIfExists(file, "UTF-8");
    }

    public String get(String key) {
        return this.getV(key, null) == null ? null : String.valueOf(this.getV(key, null));
    }

    public Object getObj(String key) {
        return this.getV(key, null);
    }

    private Object getV(String key, String def) {
        String ret = def;
        if (this.isYml) {
            if (null != this.properties.get(key)) {
                return this.properties.get(key).toString();
            }
            String[] strs = key.split("\\.");
            Object temp = null;
            for (int i = 0; i < strs.length; ++i) {
                String str = strs[i];
                if (str.length() < 1) continue;
                if (i == 0) {
                    temp = this.properties.get(str);
                    continue;
                }
                if (i == strs.length - 1) {
                    if (!(temp instanceof Map) || null == ((Map)temp).get(str)) continue;
                    ret = ((Map)temp).get(str);
                    continue;
                }
                if (null == temp || !(temp instanceof Map) || null == ((Map)temp).get(str)) continue;
                temp = ((Map)temp).get(str);
            }
        } else {
            ret = this.properties.getProperty(key);
        }
        return ret;
    }

    public String get(String key, String defaultValue) {
        return this.getV(key, defaultValue) == null ? defaultValue : String.valueOf(this.getV(key, defaultValue));
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return Long.parseLong(value.trim());
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.get(key);
        if (value != null) {
            if ("true".equals(value = value.toLowerCase().trim())) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new RuntimeException("The value can not parse to Boolean : " + value);
        }
        return defaultValue;
    }

    public boolean containsKey(String key) {
        if (this.isYml) {
            if (null != this.properties.get(key)) {
                return true;
            }
            Object ret = null;
            String[] strs = key.split("\\.");
            Object temp = null;
            for (int i = 0; i < strs.length; ++i) {
                String str = strs[i];
                if (str.length() < 1) continue;
                if (i == 0) {
                    temp = this.properties.get(str);
                    continue;
                }
                if (i == strs.length - 1) {
                    if (!(temp instanceof Map) || null == ((Map)temp).get(str)) continue;
                    ret = ((Map)temp).get(str);
                    continue;
                }
                if (null == temp || !(temp instanceof Map) || null == ((Map)temp).get(str)) continue;
                temp = ((Map)temp).get(str);
            }
            return null != ret;
        }
        return this.properties.containsKey(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean notEmpty() {
        return !this.properties.isEmpty();
    }

    public Properties getProperties() {
        return this.properties;
    }
}

