/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import space.yizhu.kits.SysKit;

public class DateKit {
    private final String README = "\n\u5b57\u6bcd\t\u63cf\u8ff0\t\u793a\u4f8b\nG\t\u7eaa\u5143\u6807\u8bb0\tAD\ny\t\u56db\u4f4d\u5e74\u4efd\t2001\nM\t\u6708\u4efd\tJuly or 07\nd\t\u4e00\u4e2a\u6708\u7684\u65e5\u671f\t10\nh\t A.M./P.M. (1~12)\u683c\u5f0f\u5c0f\u65f6\t12\nH\t\u4e00\u5929\u4e2d\u7684\u5c0f\u65f6 (0~23)\t22\nm\t\u5206\u949f\u6570\t30\ns\t\u79d2\u6570\t55\nS\t\u6beb\u79d2\u6570\t234\nE\t\u661f\u671f\u51e0\tTuesday\nD\t\u4e00\u5e74\u4e2d\u7684\u65e5\u5b50\t360\nF\t\u4e00\u4e2a\u6708\u4e2d\u7b2c\u51e0\u5468\u7684\u5468\u51e0\t2 (second Wed. in July)\nw\t\u4e00\u5e74\u4e2d\u7b2c\u51e0\u5468\t40\nW\t\u4e00\u4e2a\u6708\u4e2d\u7b2c\u51e0\u5468\t1\na\tA.M./P.M. \u6807\u8bb0\tPM\nk\t\u4e00\u5929\u4e2d\u7684\u5c0f\u65f6(1~24)\t24\nK\t A.M./P.M. (0~11)\u683c\u5f0f\u5c0f\u65f6\t10\nz\t\u65f6\u533a\tEastern Standard Time\n'\t\u6587\u5b57\u5b9a\u754c\u7b26\tDelimiter\n\"\t\u5355\u5f15\u53f7\t`";

    public static String formatDate(Date date) {
        return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    public static String now() {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String nowTimestamp() {
        return new Date().getTime() / 1000L + "";
    }

    public static boolean timestampJudge(String timestamp) {
        try {
            if (timestamp.length() < 12) {
                timestamp = timestamp + "000";
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String d = format.format(Long.parseLong(timestamp));
            Date date = format.parse(d);
            long jetLag = new Date().getTime() - date.getTime();
            return jetLag < 3600000L && jetLag > -180000L;
        }
        catch (ParseException e) {
            SysKit.print(e, "timestampJudge");
            return false;
        }
    }

    public static Date parseDate(String date) {
        if (date.endsWith(".") || date.endsWith(":")) {
            date = date.substring(0, date.length() - 1);
        }
        try {
            return DateUtils.parseDate((String)date, (String[])new String[]{"yyyy-MM", "yyyyMM", "yyyy/MM", "yyyyMMdd", "yyyy-MM-dd", "yyyy/MM/dd", "yyyyMMddHHmmss", "yyyy-MM-ddHH:mm:ss", "yyyy-MM-ddHH:mm:ss.S", "yyyy/MM/ddHH:mm:ss", "MMM dd, yyyy hh:mm:ss a", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-ddHH:mm:ss.S", "EEE MMM dd HH:mm:ss zzz yyyy"});
        }
        catch (ParseException e) {
            SysKit.print(e);
            return null;
        }
    }

    public static String formatDate(Date date, String format) {
        return DateFormatUtils.format((Date)date, (String)format);
    }

    public static String formatTime(Date date) {
        return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static List<String> listAll(String month) {
        ArrayList<String> all = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        int nm = cal.get(2);
        int nd = cal.get(5);
        try {
            cal.setTime(DateUtils.parseDate((String)month, (String[])new String[]{"yyyy-MM"}));
            cal.set(5, 1);
            int m = cal.get(2);
            while (cal.get(2) == m && m <= nm) {
                if (m < nm || m == nm && nd >= cal.get(5)) {
                    all.add(DateKit.formatDate(cal.getTime(), "MM-dd"));
                }
                cal.add(5, 1);
            }
        }
        catch (ParseException e) {
            SysKit.print(e);
        }
        return all;
    }

    public static String Data2String(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = sdf.format(d);
        return str;
    }

    public static String Data2StringD(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String str = sdf.format(d);
        return str;
    }

    public static Date String2Date(String str) {
        if (null == str || str.equals("null")) {
            return null;
        }
        if (str.contains(".")) {
            str = str.substring(0, str.indexOf("."));
        }
        SimpleDateFormat sdf = null;
        if (str.contains("+")) {
            str = str.substring(0, str.indexOf("+"));
        }
        if (str.contains("-")) {
            sdf = str.length() < 6 ? new SimpleDateFormat("MM-dd") : (str.length() < 8 ? new SimpleDateFormat("yyyy-MM") : (str.length() < 11 ? new SimpleDateFormat("yyyy-MM-dd") : (str.length() < 14 ? new SimpleDateFormat("yyyy-MM-dd HH") : (str.length() < 17 ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")))));
        } else if (!str.contains("-") && str.contains(":")) {
            Date date = new Date();
            date.setHours(Integer.parseInt(str.split(":")[0]));
            date.setMinutes(Integer.parseInt(str.split(":")[1]));
        } else {
            str = DateKit.timeStamp2Date(str, null);
        }
        Date da = null;
        try {
            da = sdf.parse(str);
        }
        catch (ParseException e) {
            da = new Date();
        }
        return da;
    }

    public static Timestamp string2Timestamp(String string) {
        return new Timestamp(Objects.requireNonNull(DateKit.parseDate(string)).getTime());
    }

    public static String timeStamp2Date(String seconds, String format) {
        if (seconds == null || seconds.isEmpty() || seconds.equals("null")) {
            return "";
        }
        seconds = seconds + "000";
        if (format == null || format.isEmpty()) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(Long.valueOf(seconds)));
    }

    public static void main(String[] args) {
        String s = "2021-12-04 09:18:52.0";
        DateKit.parseDate(s);
    }
}

