/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import space.yizhu.bean.BaseModel;
import space.yizhu.bean.LogModel;
import space.yizhu.kits.BeanKit;
import space.yizhu.kits.SysKit;
import space.yizhu.record.plugin.activerecord.ActiveRecordPlugin;
import space.yizhu.record.plugin.activerecord.CaseInsensitiveContainerFactory;
import space.yizhu.record.plugin.activerecord.Db;
import space.yizhu.record.plugin.activerecord.dialect.AnsiSqlDialect;
import space.yizhu.record.plugin.activerecord.dialect.MysqlDialect;
import space.yizhu.record.plugin.activerecord.dialect.OracleDialect;
import space.yizhu.record.plugin.activerecord.dialect.PostgreSqlDialect;
import space.yizhu.record.plugin.activerecord.dialect.SqlServerDialect;
import space.yizhu.record.plugin.activerecord.dialect.Sqlite3Dialect;
import space.yizhu.record.plugin.druid.DruidPlugin;
import space.yizhu.record.template.source.ClassPathSourceFactory;

public class DbKit {
    private static boolean saveDblog = false;
    public static String logTableName = null;
    private static ActiveRecordPlugin activeRecordPlugin = null;
    private static HashMap<String, Class<? extends BaseModel<?>>> mappings = null;
    private static String logTableSq = "create table ${0}\n(\n    id          bigint auto_increment primary key comment '\u7a0b\u5e8f\u67e5\u8be2\uff0c\u66f4\u65b0\u65f6\u4f7f\u7528id',\n    code        varchar(100)                         null comment '\u8bf7\u6c42\u7684\u65b9\u6cd5',\n    name        varchar(40)                         null comment '\u57fa\u672c\u7ed3\u6784-$(\u8868)\u6ce8\u91ca\u548c\u8bf4\u660e',\n    creator     varchar(20)                         null comment '\u521b\u5efa\u8005code',\n    mender      varchar(20)                         null comment '\u4fee\u6539\u8005code',\n    create_time timestamp default CURRENT_TIMESTAMP null,\n    modify_time timestamp default CURRENT_TIMESTAMP null,\n    is_del      bit       default b'0'              null comment '\u662f\u5426\u88ab\u5220\u9664\u30021\u662f0\u5426',\n    ext_i       int                                 null comment '\u6269\u5c55\u5b57\u6bb5\uff0c\u5b58\u50a8\u72b6\u6001\u6216\u6570\u5b57\uff0c\u6700\u59272^32',\n    ext_c       varchar(40)                         null comment '\u6269\u5c55\u5b57\u6bb5\uff0c\u6700\u591a\u5b58\u50a840\u5b57\u7b26\u957f\u5ea6',\n    ext_j       json                                null comment '\u5b58\u50a8json\u5b57\u6bb5',\n    ext_t       text                                null comment '\u5b58\u50a8text\u5b57\u6bb5',\n    type       tinyint       default 0               null comment '\u65e5\u5fd7\u7c7b\u578b\uff0c\u9ed8\u8ba40\u63a5\u53e3\u65e5\u5fd7\uff0c1\u662f\u6570\u636e\u5e93\u63d2\u5165\uff0c2\u662f\u6570\u636e\u66f4\u65b0\uff0c3\u6570\u636e\u5e93\u5220\u9664\uff0c\u6570\u636e\u5e93\uff0c\u65e7\u6570\u636e\u662fparams\uff0c\u65b0\u6570\u636e\u662freturned',    heads       text                                null comment '\u53c2\u6570\u5934',\n    params      text                                null comment '\u53c2\u6570',\n    returned      text                              null comment '\u8fd4\u56de\u6570\u636e',\n    from_addr     varchar(50)                       null comment '\u6765\u6e90\u5730\u5740',\n    cost_time   int                                 null  comment '\u8017\u65f6ms'\n\n)";
    private static String logTableIndex = "create index ${0}_creator_index\n    on ${0} (creator)";

    public static void init(String url, String uName, String uPw) {
        DbKit.init(url, uName, uPw, null);
    }

    public static void init(String url, String uName, String uPw, String logTableName) {
        String sqlName;
        DruidPlugin druidPlugin;
        block21: {
            druidPlugin = null;
            sqlName = url.substring(0, url.indexOf("://"));
            try {
                druidPlugin = new DruidPlugin(url, uName, uPw);
            }
            catch (Exception e) {
                if (null == e.getMessage()) break block21;
                SysKit.print(e, "\u6570\u636e\u5e93\u521d\u59cb\u5316\u5931\u8d25");
            }
        }
        activeRecordPlugin = new ActiveRecordPlugin(druidPlugin);
        activeRecordPlugin.getEngine().setSourceFactory(new ClassPathSourceFactory());
        if (sqlName.toLowerCase().contains("mysql")) {
            activeRecordPlugin.setDialect(new MysqlDialect());
        } else if (sqlName.toLowerCase().contains("sqlse")) {
            activeRecordPlugin.setDialect(new SqlServerDialect());
        } else if (sqlName.toLowerCase().contains("oracle")) {
            activeRecordPlugin.setDialect(new OracleDialect());
        } else if (sqlName.toLowerCase().contains("ansi")) {
            activeRecordPlugin.setDialect(new AnsiSqlDialect());
        } else if (sqlName.toLowerCase().contains("post")) {
            activeRecordPlugin.setDialect(new PostgreSqlDialect());
        } else if (sqlName.toLowerCase().contains("sqlite") || sqlName.toLowerCase().contains("sqllite")) {
            activeRecordPlugin.setDialect(new Sqlite3Dialect());
        }
        activeRecordPlugin.setContainerFactory(new CaseInsensitiveContainerFactory(true));
        for (Map.Entry<String, BaseModel<?>> entry : BeanKit.beanMap.entrySet()) {
            if (null == entry.getValue()) continue;
            activeRecordPlugin.addMapping(entry.getKey(), entry.getValue().getClass());
        }
        if (null != mappings && mappings.size() > 0) {
            for (Map.Entry<String, Serializable> entry : mappings.entrySet()) {
                if (null == entry.getKey() || null == entry.getValue()) continue;
                activeRecordPlugin.addMapping(entry.getKey(), (Class)entry.getValue());
            }
        }
        if (logTableName != null && logTableName.length() > 1) {
            DbKit.logTableName = logTableName;
            activeRecordPlugin.addMapping(logTableName, LogModel.class);
        }
        if (druidPlugin != null) {
            druidPlugin.start();
            activeRecordPlugin.start();
            SysKit.print("active[" + sqlName + "]\u6570\u636e\u5e93\u94fe\u63a5\u542f\u52a8\u6210\u529f");
            if (null != logTableName && logTableName.length() > 2) {
                try {
                    Db.query("SELECT * FROM " + logTableName + " limit 1");
                }
                catch (Exception e) {
                    SysKit.print("\u65e5\u5fd7\u8868\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u65e5\u5fd7\u8868");
                    Db.update(logTableSq.replace("${0}", logTableName));
                    SysKit.print("\u65e5\u5fd7\u8868" + logTableName + "\u521b\u5efa\u5b8c\u6210");
                    Db.update(logTableIndex.replaceAll("\\$\\{0\\}", logTableName));
                    SysKit.print("\u65e5\u5fd7\u8868" + logTableName + "\u7d22\u5f15\u6dfb\u52a0\u5b8c\u6210");
                }
            }
        }
    }

    public static void addMapping(String table, Class<? extends BaseModel<?>> cls) {
        if (null == cls) {
            return;
        }
        if (null == activeRecordPlugin) {
            if (null == mappings) {
                mappings = new HashMap();
            }
            if (null != table) {
                mappings.put(table, cls);
            }
            return;
        }
        activeRecordPlugin.stop();
        activeRecordPlugin.addMapping(table, cls);
        activeRecordPlugin.start();
    }

    public static void addMapping(Map<String, Class<? extends BaseModel<?>>> map) {
        if (map == null) {
            return;
        }
        if (null == activeRecordPlugin) {
            if (null == mappings) {
                mappings = new HashMap();
            }
            for (Map.Entry<String, Class<BaseModel<?>>> cls : map.entrySet()) {
                if (null == cls || null == cls.getKey() || null == cls.getValue()) continue;
                mappings.put(cls.getKey(), cls.getValue());
            }
            return;
        }
        activeRecordPlugin.stop();
        for (Map.Entry<String, Class<BaseModel<?>>> cls : map.entrySet()) {
            if (null == cls || null == cls.getKey() || null == cls.getValue()) continue;
            mappings.put(cls.getKey(), cls.getValue());
        }
        activeRecordPlugin.start();
    }

    public static ActiveRecordPlugin getActiveRecord() {
        return activeRecordPlugin;
    }

    public static boolean isSaveDblog() {
        return saveDblog;
    }

    public static void setSaveDblog(boolean saveDblog) {
        DbKit.saveDblog = saveDblog;
    }
}

