/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import space.yizhu.kits.SysKit;

public class DictKit {
    private static final SensitiveStringDecoder[] AVAIL_ENCODINGS = new SensitiveStringDecoder[]{new SensitiveStringDecoder(StandardCharsets.UTF_8), new SensitiveStringDecoder(Charset.forName("GBK")), new SensitiveStringDecoder(StandardCharsets.UTF_16LE), new SensitiveStringDecoder(StandardCharsets.UTF_16BE), new SensitiveStringDecoder(Charset.forName("EUC-JP"))};
    public static Map<String, String> ld = new HashMap<String, String>(){
        {
            this.put("code", "\u7f16\u7801");
            this.put("name", "\u540d\u79f0");
            this.put("creator", "\u521b\u5efa\u8005");
            this.put("mender", "\u4fee\u6539\u4eba");
            this.put("result", "\u503c");
            this.put("time", "\u65f6\u95f4");
            this.put("create", "\u521b\u5efa");
            this.put("create_time", "\u521b\u5efa\u65f6\u95f4");
            this.put("modify", "\u66f4\u65b0");
            this.put("modify_time", "\u66f4\u65b0\u65f6\u95f4");
            this.put("url", "\u5730\u5740");
            this.put("sort", "\u5e8f\u53f7");
            this.put("parent", "\u7236\u7ea7");
            this.put("type", "\u7c7b\u578b");
            this.put("is", "\u662f\u5426");
            this.put("del", "\u5220\u9664");
            this.put("group", "\u7fa4\u7ec4");
            this.put("organization", "\u7ec4\u7ec7");
            this.put("competence", "\u6743\u9650");
            this.put("identity", "\u8bc1\u4ef6\u53f7");
            this.put("telephone", "\u624b\u673a\u53f7");
            this.put("birthday", "\u751f\u65e5");
            this.put("gender", "\u6027\u522b");
            this.put("password", "\u5bc6\u7801");
            this.put("email", "\u90ae\u7bb1");
            this.put("main", "\u4e3b\u8981");
            this.put("is_main", "\u4e3b\u952e");
            this.put("is_del", "\u5df2\u5220\u9664");
            this.put("id", "\u5e8f\u5217\u53f7");
            this.put("picture", "\u56fe\u7247");
            this.put("pic", "\u56fe\u7247");
            this.put("image", "\u56fe\u7247");
            this.put("img", "\u56fe\u7247");
        }
    };

    public static String getChinese(String english) {
        if (english == null) {
            return "";
        }
        String[] ens = english.toLowerCase().split("_");
        StringBuilder cn = new StringBuilder();
        for (String en : ens) {
            if (ld.get(en) == null) continue;
            cn.append(ld.get(en));
        }
        if (cn.length() > 0) {
            return cn.toString();
        }
        return english;
    }

    public static String getSort(String english) {
        return "";
    }

    public static final long decompress(String inflatedFile, ByteBuffer data, int offset, int length, boolean append) throws IOException {
        Inflater inflator = new Inflater();
        try (InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(data.array(), offset, length), inflator, 8192);
             FileOutputStream out = new FileOutputStream(inflatedFile, append);){
            DictKit.writeInputStream(in, out);
        }
        long bytesRead = inflator.getBytesRead();
        inflator.end();
        return bytesRead;
    }

    public static final SensitiveStringDecoder[] detectEncodings(ByteBuffer inflatedBytes, int offsetWords, int offsetXml, int defTotal, int dataLen, int[] idxData, String[] defData) {
        int test = Math.min(defTotal, 10);
        for (int j = 0; j < AVAIL_ENCODINGS.length; ++j) {
            for (int k = 0; k < AVAIL_ENCODINGS.length; ++k) {
                try {
                    for (int i = 0; i < test; ++i) {
                        DictKit.readDefinitionData(inflatedBytes, offsetWords, offsetXml, dataLen, AVAIL_ENCODINGS[j], AVAIL_ENCODINGS[k], idxData, defData, i);
                    }
                    return new SensitiveStringDecoder[]{AVAIL_ENCODINGS[j], AVAIL_ENCODINGS[k]};
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
        }
        System.err.println("\u81ea\u52a8\u8bc6\u522b\u7f16\u7801\u5931\u8d25\uff01\u9009\u62e9UTF-16LE\u7ee7\u7eed\u3002");
        return new SensitiveStringDecoder[]{AVAIL_ENCODINGS[1], AVAIL_ENCODINGS[1]};
    }

    public static final void extract(String inflatedFile, String indexFile, String extractedWordsFile, String extractedXmlFile, String extractedOutputFile, int[] idxArray, int offsetDefs, int offsetXml) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        int counter = 0;
        try (RandomAccessFile file = new RandomAccessFile(inflatedFile, "r");
             FileChannel fChannel = file.getChannel();){
            ByteBuffer dataRawBytes = ByteBuffer.allocate((int)fChannel.size());
            fChannel.read(dataRawBytes);
            fChannel.close();
            dataRawBytes.order(ByteOrder.LITTLE_ENDIAN);
            dataRawBytes.rewind();
            int dataLen = 10;
            int defTotal = offsetDefs / 10 - 1;
            String[] words = new String[defTotal];
            int[] idxData = new int[6];
            String[] defData = new String[2];
            SensitiveStringDecoder[] encodings = DictKit.detectEncodings(dataRawBytes, offsetDefs, offsetXml, defTotal, 10, idxData, defData);
            dataRawBytes.position(8);
            for (int i = 0; i < defTotal; ++i) {
                DictKit.readDefinitionData(dataRawBytes, offsetDefs, offsetXml, 10, encodings[0], encodings[1], idxData, defData, i);
                try {
                    ld.putIfAbsent(defData[0], defData[1].substring(defData[1].contains(".") ? defData[1].indexOf(".") + 1 : 0, defData[1].contains("\uff0c") || defData[1].contains("\uff1b") ? (defData[1].contains("\uff0c") && defData[1].indexOf("\uff0c") < defData[1].indexOf("\uff1b") || !defData[1].contains("\uff1b") ? defData[1].indexOf("\uff0c") : defData[1].indexOf("\uff1b")) : defData[1].length()));
                    ++counter;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ld.put("updator", "\u66f4\u65b0\u8005");
        ld.put("code", "\u7f16\u7801");
        ld.put("is", "\u53ef");
        ld.put("sn", "\u8bbe\u5907\u6807\u8bc6");
        ld.put("items", "\u6761\u76ee");
        ld.put("waste", "\u5e9f\u5f03");
        ld.put("main", "\u4e3b\u6807\u8bc6");
        ld.put("remark", "\u5907\u6ce8");
        ld.put("sort", "\u6392\u5e8f");
        SysKit.print("\u5b57\u5178\u52a0\u8f7d\u6210\u529f" + counter);
    }

    public static final void getIdxData(ByteBuffer dataRawBytes, int position, int[] wordIdxData) {
        dataRawBytes.position(position);
        wordIdxData[0] = dataRawBytes.getInt();
        wordIdxData[1] = dataRawBytes.getInt();
        wordIdxData[2] = dataRawBytes.get() & 0xFF;
        wordIdxData[3] = dataRawBytes.get() & 0xFF;
        wordIdxData[4] = dataRawBytes.getInt();
        wordIdxData[5] = dataRawBytes.getInt();
    }

    public static final void inflate(ByteBuffer dataRawBytes, List<Integer> deflateStreams, String inflatedFile) {
        System.out.println("\u89e3\u538b\u7f29'" + deflateStreams.size() + "'\u4e2a\u6570\u636e\u6d41\u81f3'" + inflatedFile + "'\u3002\u3002\u3002");
        int startOffset = dataRawBytes.position();
        int offset = -1;
        int lastOffset = startOffset;
        boolean append = false;
        try {
            for (Integer offsetRelative : deflateStreams) {
                offset = startOffset + offsetRelative;
                DictKit.decompress(inflatedFile, dataRawBytes, lastOffset, offset - lastOffset, append);
                append = true;
                lastOffset = offset;
            }
        }
        catch (Throwable e) {
            System.err.println("\u89e3\u538b\u7f29\u5931\u8d25: 0x" + Integer.toHexString(offset) + ": " + e.toString());
        }
    }

    public static final void readDefinitionData(ByteBuffer inflatedBytes, int offsetWords, int offsetXml, int dataLen, SensitiveStringDecoder wordStringDecoder, SensitiveStringDecoder xmlStringDecoder, int[] idxData, String[] defData, int i) {
        String word;
        DictKit.getIdxData(inflatedBytes, dataLen * i, idxData);
        int lastWordPos = idxData[0];
        int lastXmlPos = idxData[1];
        int refs = idxData[3];
        int currentWordOffset = idxData[4];
        int currenXmlOffset = idxData[5];
        String xml = DictKit.strip(new String(xmlStringDecoder.decode(inflatedBytes.array(), offsetXml + lastXmlPos, currenXmlOffset - lastXmlPos)));
        while (refs-- > 0) {
            int ref = inflatedBytes.getInt(offsetWords + lastWordPos);
            DictKit.getIdxData(inflatedBytes, dataLen * ref, idxData);
            lastXmlPos = idxData[1];
            currenXmlOffset = idxData[5];
            xml = xml.isEmpty() ? DictKit.strip(new String(xmlStringDecoder.decode(inflatedBytes.array(), offsetXml + lastXmlPos, currenXmlOffset - lastXmlPos))) : DictKit.strip(new String(xmlStringDecoder.decode(inflatedBytes.array(), offsetXml + lastXmlPos, currenXmlOffset - lastXmlPos))) + ", " + xml;
            lastWordPos += 4;
        }
        defData[1] = xml;
        defData[0] = word = new String(wordStringDecoder.decode(inflatedBytes.array(), offsetWords + lastWordPos, currentWordOffset - lastWordPos));
    }

    public static final void readDictionary(String ld2File, ByteBuffer dataRawBytes, int offsetWithIndex) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        int limit = dataRawBytes.getInt(offsetWithIndex + 4) + offsetWithIndex + 8;
        int offsetIndex = offsetWithIndex + 28;
        int offsetCompressedDataHeader = dataRawBytes.getInt(offsetWithIndex + 8) + offsetIndex;
        int inflatedWordsIndexLength = dataRawBytes.getInt(offsetWithIndex + 12);
        int inflatedWordsLength = dataRawBytes.getInt(offsetWithIndex + 16);
        int inflatedXmlLength = dataRawBytes.getInt(offsetWithIndex + 20);
        int definitions = (offsetCompressedDataHeader - offsetIndex) / 4;
        ArrayList<Integer> deflateStreams = new ArrayList<Integer>();
        dataRawBytes.position(offsetCompressedDataHeader + 8);
        int offset = dataRawBytes.getInt();
        while (offset + dataRawBytes.position() < limit) {
            offset = dataRawBytes.getInt();
            deflateStreams.add(offset);
        }
        int offsetCompressedData = dataRawBytes.position();
        String inflatedFile = ld2File + ".inflated";
        DictKit.inflate(dataRawBytes, deflateStreams, inflatedFile);
        if (new File(inflatedFile).isFile()) {
            String indexFile = ld2File + ".idx";
            String extractedFile = ld2File + ".words";
            String extractedXmlFile = ld2File + ".xml";
            String extractedOutputFile = ld2File + ".output";
            dataRawBytes.position(offsetIndex);
            int[] idxArray = new int[definitions];
            for (int i = 0; i < definitions; ++i) {
                idxArray[i] = dataRawBytes.getInt();
            }
            DictKit.extract(inflatedFile, indexFile, extractedFile, extractedXmlFile, extractedOutputFile, idxArray, inflatedWordsIndexLength, inflatedWordsIndexLength + inflatedWordsLength);
        }
    }

    public static final String strip(String xml) {
        int open = 0;
        int end = 0;
        open = xml.indexOf("<![CDATA[");
        if (open != -1) {
            end = xml.indexOf("]]>", open);
            if (end != -1) {
                return xml.substring(open + "<![CDATA[".length(), end).replace('\t', ' ').replace('\n', ' ').replace('\u001e', ' ').replace('\u001f', ' ');
            }
        } else {
            open = xml.indexOf("<\u00d4");
            if (open != -1) {
                end = xml.indexOf("</\u00d4", open);
                if (end != -1) {
                    open = xml.indexOf(">", open + 1);
                    return xml.substring(open + 1, end).replace('\t', ' ').replace('\n', ' ').replace('\u001e', ' ').replace('\u001f', ' ');
                }
            } else {
                StringBuilder sb = new StringBuilder();
                end = 0;
                open = xml.indexOf(60);
                do {
                    if (open - end > 1) {
                        sb.append(xml.substring(end + 1, open));
                    }
                    open = xml.indexOf(60, open + 1);
                    end = xml.indexOf(62, end + 1);
                } while (open != -1 && end != -1);
                return sb.toString().replace('\t', ' ').replace('\n', ' ').replace('\u001e', ' ').replace('\u001f', ' ');
            }
        }
        return "";
    }

    public static final void writeInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    public static void startDict() throws IOException {
        File file = new File(System.getProperty("user.dir"));
        if (file.exists() && file.isDirectory()) {
            for (File f : Objects.requireNonNull(file.listFiles())) {
                if (!f.isFile() || !f.getName().endsWith(".ld2")) continue;
                DictKit.startDictFile(f.getAbsolutePath());
            }
        }
        if ((file = new File(System.getProperty("user.dir") + "/dicts")).exists() && file.isDirectory()) {
            for (File f : Objects.requireNonNull(file.listFiles())) {
                if (!f.isFile() || !f.getName().endsWith(".ld2")) continue;
                DictKit.startDictFile(f.getAbsolutePath());
            }
        }
        if ((file = new File(System.getProperty("user.dir") + "/dict")).exists() && file.isDirectory()) {
            for (File f : Objects.requireNonNull(file.listFiles())) {
                if (!f.isFile() || !f.getName().endsWith(".ld2")) continue;
                DictKit.startDictFile(f.getAbsolutePath());
            }
        }
    }

    public static void startDictFile(String ld2File) throws IOException {
        ByteBuffer dataRawBytes;
        if (ld2File == null) {
            ld2File = System.getProperty("user.dir") + "/English-Chinese.ld2";
        }
        try (RandomAccessFile file = new RandomAccessFile(ld2File, "r");
             FileChannel fChannel = file.getChannel();){
            dataRawBytes = ByteBuffer.allocate((int)fChannel.size());
            fChannel.read(dataRawBytes);
        }
        dataRawBytes.order(ByteOrder.LITTLE_ENDIAN);
        dataRawBytes.rewind();
        int offsetData = dataRawBytes.getInt(92) + 96;
        if (dataRawBytes.limit() > offsetData) {
            int type = dataRawBytes.getInt(offsetData);
            int offsetWithInfo = dataRawBytes.getInt(offsetData + 4) + offsetData + 12;
            if (type == 3) {
                DictKit.readDictionary(ld2File, dataRawBytes, offsetData);
            } else if (dataRawBytes.limit() > offsetWithInfo - 28) {
                DictKit.readDictionary(ld2File, dataRawBytes, offsetWithInfo);
            } else {
                System.err.println("\u6587\u4ef6\u4e0d\u5305\u542b\u5b57\u5178\u6570\u636e\u3002\u7f51\u4e0a\u5b57\u5178\uff1f");
            }
        } else {
            System.err.println("\u6587\u4ef6\u4e0d\u5305\u542b\u5b57\u5178\u6570\u636e\u3002\u7f51\u4e0a\u5b57\u5178\uff1f");
        }
    }

    public static class SensitiveStringDecoder {
        public final String name;
        private final CharsetDecoder cd;

        SensitiveStringDecoder(Charset cs) {
            this.cd = cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.name = cs.name();
        }

        private static char[] safeTrim(char[] ca, int len) {
            if (len == ca.length) {
                return ca;
            }
            return Arrays.copyOf(ca, len);
        }

        char[] decode(byte[] ba, int off, int len) {
            int en = (int)((double)len * (double)this.cd.maxCharsPerByte());
            char[] ca = new char[en];
            if (len == 0) {
                return ca;
            }
            this.cd.reset();
            ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
            CharBuffer cb = CharBuffer.wrap(ca);
            try {
                CoderResult cr = this.cd.decode(bb, cb, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = this.cd.flush(cb)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException x) {
                throw new Error(x);
            }
            return SensitiveStringDecoder.safeTrim(ca, cb.position());
        }
    }
}

