/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.stream.Collectors;
import space.yizhu.kits.StrKit;
import space.yizhu.kits.SysKit;

public class FileKit {
    public static void delete(File file) {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        FileKit.delete(files[i]);
                    }
                }
                file.delete();
            }
        }
    }

    public static String read(File file) {
        BufferedReader bufferedReader = null;
        String strs = "";
        if (!file.exists()) {
            return strs;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            LineNumberReader reader = new LineNumberReader(bufferedReader);
            strs = reader.lines().collect(Collectors.joining());
            reader.close();
        }
        catch (FileNotFoundException e) {
            SysKit.print(e);
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        return strs;
    }

    public static String read(File file, long startRows) {
        BufferedReader bufferedReader = null;
        String strs = "";
        if (!file.exists()) {
            return strs;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            LineNumberReader reader = new LineNumberReader(bufferedReader);
            while ((long)reader.getLineNumber() < startRows) {
                reader.readLine();
            }
            strs = reader.lines().collect(Collectors.joining());
            reader.close();
        }
        catch (FileNotFoundException e) {
            SysKit.print(e);
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        return strs;
    }

    public static String read(File file, long startRows, long lens) {
        BufferedReader bufferedReader = null;
        String strs = "";
        if (!file.exists()) {
            return strs;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            LineNumberReader reader = new LineNumberReader(bufferedReader);
            while ((long)reader.getLineNumber() < startRows) {
                reader.readLine();
            }
            while (lens-- > 0L) {
                strs = strs + reader.readLine() + "\r\n";
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            SysKit.print(e);
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        return strs;
    }

    static long getTotalLines(String fileName) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        LineNumberReader reader = new LineNumberReader(in);
        long lines = reader.lines().count();
        reader.close();
        in.close();
        return lines;
    }

    public static String getFileExtension(String fileFullName) {
        if (StrKit.isBlank(fileFullName)) {
            throw new RuntimeException("fileFullName is empty");
        }
        return FileKit.getFileExtension(new File(fileFullName));
    }

    public static String getFileExtension(File file) {
        if (null == file) {
            throw new NullPointerException();
        }
        String fileName = file.getName();
        int dotIdx = fileName.lastIndexOf(46);
        return dotIdx == -1 ? "" : fileName.substring(dotIdx + 1);
    }

    public static String getUsrDir() {
        return System.getProperty("user.dir");
    }

    public static void main(String[] args) {
        SysKit.print(FileKit.read(new File(FileKit.getUsrDir() + "/README.md"), 3L));
    }
}

