/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import space.yizhu.kits.ConfigFile;

public class FitKit {
    private static ConfigFile configFile = null;
    private static final ConcurrentHashMap<String, ConfigFile> map = new ConcurrentHashMap();

    private FitKit() {
    }

    public static ConfigFile use(String fileName) {
        return FitKit.use(fileName, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigFile use(String fileName, String encoding) {
        ConfigFile result = map.get(fileName);
        if (result != null) return result;
        Class<FitKit> clazz = FitKit.class;
        synchronized (FitKit.class) {
            result = map.get(fileName);
            if (result != null) return result;
            result = new ConfigFile(fileName, encoding);
            map.put(fileName, result);
            if (configFile != null) return result;
            configFile = result;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public static ConfigFile use(File file) {
        return FitKit.use(file, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigFile use(File file, String encoding) {
        ConfigFile result = map.get(file.getName());
        if (result != null) return result;
        Class<FitKit> clazz = FitKit.class;
        synchronized (FitKit.class) {
            result = map.get(file.getName());
            if (result != null) return result;
            result = new ConfigFile(file, encoding);
            map.put(file.getName(), result);
            if (configFile != null) return result;
            configFile = result;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public static ConfigFile useless(String fileName) {
        ConfigFile previous = map.remove(fileName);
        if (configFile == previous) {
            configFile = null;
        }
        return previous;
    }

    public static void clear() {
        configFile = null;
        map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigFile append(ConfigFile configFile) {
        Class<FitKit> clazz = FitKit.class;
        synchronized (FitKit.class) {
            if (FitKit.configFile != null) {
                FitKit.configFile.append(configFile);
            } else {
                FitKit.configFile = configFile;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return FitKit.configFile;
        }
    }

    public static ConfigFile append(String fileName, String encoding) {
        return FitKit.append(new ConfigFile(fileName, encoding));
    }

    public static ConfigFile append(String fileName) {
        return FitKit.append(fileName, "UTF-8");
    }

    public static ConfigFile appendIfExists(String fileName, String encoding) {
        try {
            return FitKit.append(new ConfigFile(fileName, encoding));
        }
        catch (Exception e) {
            return configFile;
        }
    }

    public static ConfigFile appendIfExists(String fileName) {
        return FitKit.appendIfExists(fileName, "UTF-8");
    }

    public static ConfigFile append(File file, String encoding) {
        return FitKit.append(new ConfigFile(file, encoding));
    }

    public static ConfigFile append(File file) {
        return FitKit.append(file, "UTF-8");
    }

    public static ConfigFile appendIfExists(File file, String encoding) {
        if (file.exists()) {
            FitKit.append(new ConfigFile(file, encoding));
        }
        return configFile;
    }

    public static ConfigFile appendIfExists(File file) {
        return FitKit.appendIfExists(file, "UTF-8");
    }

    public static ConfigFile getConfigFile() {
        if (configFile == null) {
            throw new IllegalStateException("Load propties file by invoking FitKit.use(String fileName) method first.");
        }
        return configFile;
    }

    public static ConfigFile getProp(String fileName) {
        return map.get(fileName);
    }

    public static String get(String key) {
        return FitKit.getConfigFile().get(key);
    }

    public static Object getObj(String key) {
        return FitKit.getConfigFile().getObj(key);
    }

    public static String get(String key, String defaultValue) {
        return FitKit.getConfigFile().get(key, defaultValue);
    }

    public static Integer getInt(String key) {
        return FitKit.getConfigFile().getInt(key);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        return FitKit.getConfigFile().getInt(key, defaultValue);
    }

    public static Long getLong(String key) {
        return FitKit.getConfigFile().getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return FitKit.getConfigFile().getLong(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return FitKit.getConfigFile().getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return FitKit.getConfigFile().getBoolean(key, defaultValue);
    }

    public static boolean containsKey(String key) {
        return FitKit.getConfigFile().containsKey(key);
    }

    public static void main(String[] args) {
        FitKit.use("app.yml").getInt("server.port");
        FitKit.getObj("test.port");
    }
}

