/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import com.alibaba.druid.support.json.JSONUtils;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import space.yizhu.kits.RSAKit;
import space.yizhu.kits.SysKit;

public class HttpKit {
    private static CloseableHttpClient httpclient = null;

    public static HttpURLConnection getLoadConnection(String url) throws IOException {
        return (HttpURLConnection)new URL(url).openConnection();
    }

    public static String load(String url) {
        return HttpKit.load(url, null, null, "GET", null);
    }

    public static String load(String url, Object params) {
        return HttpKit.load(url, params, null, "POST", null);
    }

    public static String load(String url, Object params, Map header) {
        return HttpKit.load(url, params, header, "POST", null);
    }

    public static String load(String url, Object params, String method) {
        return HttpKit.load(url, params, null, method, null);
    }

    public static String load(String url, Map header) {
        return HttpKit.load(url, null, header, "GET", null);
    }

    public static String load(HttpURLConnection connection, String url) {
        return HttpKit.load(url, null, null, "GET", connection);
    }

    public static String load(HttpURLConnection connection, String url, Map header) {
        return HttpKit.load(url, null, header, "GET", connection);
    }

    public static String load(HttpURLConnection connection, Object params, Map header) {
        return HttpKit.load(null, params, header, "POST", connection);
    }

    public static String load(HttpURLConnection connection, Object params) {
        return HttpKit.load(null, params, null, "POST", connection);
    }

    public static String load(String url, Object params, Map<String, Object> headers, String method, HttpURLConnection connection) {
        StringBuilder resultStr = new StringBuilder();
        try {
            String line;
            HttpURLConnection conn = connection == null ? (HttpURLConnection)new URL(url).openConnection() : connection;
            if (null == method || method.isEmpty()) {
                method = "POST";
            }
            conn.setRequestMethod(method.toUpperCase());
            if (headers != null) {
                for (Map.Entry<String, Object> h : headers.entrySet()) {
                    conn.setRequestProperty(h.getKey(), String.valueOf(h.getValue()));
                }
            }
            conn.setDoOutput(true);
            conn.setAllowUserInteraction(false);
            conn.setUseCaches(true);
            if (params != null) {
                OutputStream os = conn.getOutputStream();
                byte[] bytes = params != null ? (params instanceof byte[] ? (byte[])params : (params instanceof String ? params.toString().getBytes() : JSONUtils.toJSONString((Object)params).getBytes())) : new byte[]{};
                os.write(bytes, 0, bytes.length);
                os.flush();
                os.close();
            }
            BufferedReader bReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while (null != (line = bReader.readLine())) {
                resultStr.append(line);
            }
            bReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultStr.toString();
    }

    public static String httpPost(String url, Map<String, Object> map, String pubkey) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("param", RSAKit.encryption(new Gson().toJson(map), pubkey));
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry entry : req.entrySet()) {
            jsonObject.put((String)entry.getKey(), entry.getValue());
        }
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(jsonObject.toString(), "utf-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        HttpEntity entity1 = response.getEntity();
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)entity1);
        }
        catch (IOException | ParseException e) {
            SysKit.print((Exception)e);
        }
        return result;
    }

    public static String httpPost(String url, String json) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(json, "utf-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        HttpEntity entity1 = response.getEntity();
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)entity1);
        }
        catch (IOException | ParseException e) {
            SysKit.print((Exception)e);
        }
        return result;
    }

    public static String httpPostNoRSA(String url, String json) throws KeyManagementException {
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(json, "utf-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            SysKit.print(e);
        }
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)ssf).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        HttpEntity httpEntity = response.getEntity();
        String result = null;
        if (httpEntity != null) {
            try {
                result = EntityUtils.toString((HttpEntity)httpEntity);
            }
            catch (IOException | ParseException e) {
                SysKit.print((Exception)e);
            }
        } else {
            result = String.valueOf(response.getStatusLine().toString());
        }
        return result;
    }

    public static String httpPostNoRSA(String url, Map<String, Object> map) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(jsonObject.toString(), "utf-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        HttpEntity entity1 = response.getEntity();
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)entity1);
        }
        catch (IOException | ParseException e) {
            SysKit.print((Exception)e);
        }
        return result;
    }

    public static String httpPostLocalTest(String url, Map<String, Object> map) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)ssf).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(jsonObject.toString(), "utf-8");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        HttpEntity entity1 = response.getEntity();
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)entity1);
        }
        catch (IOException | ParseException e) {
            SysKit.print((Exception)e);
        }
        return result;
    }

    private static CloseableHttpClient getHttpsClient() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        PlainConnectionSocketFactory plainSF = new PlainConnectionSocketFactory();
        registryBuilder.register("http", (Object)plainSF);
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            TrustStrategy anyTrustStrategy = new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            };
            SSLContext sslContext = SSLContexts.custom().useTLS().loadTrustMaterial(trustStore, anyTrustStrategy).build();
            SSLConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            registryBuilder.register("https", (Object)sslSF);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Registry registry = registryBuilder.build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url, Map<String, Object> head) throws UnsupportedEncodingException, NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient httpclient = (url = url.replaceAll(" ", "")).startsWith("https") ? HttpKit.getHttpsClient() : HttpClients.createDefault();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(7000).setConnectionRequestTimeout(7000).setSocketTimeout(7000).setRedirectsEnabled(true).build();
        HttpGet httpget = new HttpGet(URLEncoder.encode(url, "utf-8"));
        httpget.setConfig(requestConfig);
        CloseableHttpResponse response = null;
        if (null != head && head.size() > 0) {
            for (Map.Entry<String, Object> st : head.entrySet()) {
                if (null == st.getValue() || null == st.getKey()) continue;
                httpget.addHeader(st.getKey(), st.getValue().toString());
            }
        }
        try {
            response = httpclient.execute((HttpUriRequest)httpget);
        }
        catch (IOException e1) {
            SysKit.print(e1);
        }
        String result = null;
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity);
            }
        }
        catch (IOException | ParseException e) {
            SysKit.print((Exception)e);
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                SysKit.print(e);
            }
        }
        return result;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        SysKit.print(HttpKit.load("http://yizhu.space:22333/whkfb/callback/gethtxx", new HashMap<String, String>(){
            {
                this.put("htbh", "201800037408");
                this.put("vcode", "1234");
            }
        }));
    }
}

