/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import space.yizhu.kits.Base64Kit;
import space.yizhu.kits.FileKit;

public class ImageKit {
    private ImageKit() {
    }

    public static String encodeDataUri(String imageFilePath) throws IOException {
        return ImageKit.encodeDataUri(new File(imageFilePath));
    }

    public static String encodeDataUri(File imageFile) throws IOException {
        String type = FileKit.getFileExtension(imageFile).toLowerCase();
        if ("jpg".equals(type)) {
            type = "jpeg";
        }
        return "data:image/" + type + ";base64," + ImageKit.encodeBase64(imageFile);
    }

    public static String encodeBase64(String imageFilePath) throws IOException {
        return ImageKit.encodeBase64(new File(imageFilePath));
    }

    public static String encodeBase64(File imageFile) throws IOException {
        BufferedImage bi = ImageIO.read(imageFile);
        String type = FileKit.getFileExtension(imageFile).toLowerCase();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, type, baos);
        return Base64Kit.encode(baos.toByteArray());
    }
}

