/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import space.yizhu.bean.BaseModel;
import space.yizhu.kits.DictKit;
import space.yizhu.kits.SortKit;
import space.yizhu.kits.SysKit;
import space.yizhu.record.plugin.activerecord.Model;
import space.yizhu.record.plugin.activerecord.Record;

public class ModelKit {
    static Gson gson = new Gson();

    public static BaseModel<? extends BaseModel> toModel(Record record, BaseModel<? extends BaseModel> model) {
        String[] attrs;
        for (String entry : attrs = record.getColumnNames()) {
            model.set(entry, record.get(entry));
        }
        return model;
    }

    public static List<? extends BaseModel> toModels(List<Record> records, BaseModel<? extends BaseModel> model) {
        ArrayList<BaseModel<? extends BaseModel>> models = new ArrayList<BaseModel<? extends BaseModel>>();
        for (Record record : records) {
            models.add(ModelKit.toModel(record, model));
        }
        return models;
    }

    public static Map toJson(List<? extends BaseModel> models, BaseModel<?> model, String removal) {
        String[] keysT = new String[]{};
        if (model != null) {
            keysT = model.getField();
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> keysN = new ArrayList<Object>();
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        HashMap<Integer, String> sortMap = new HashMap<Integer, String>();
        if (removal == null) {
            removal = ",";
        }
        if ((removal = removal.toLowerCase()).endsWith(",")) {
            removal = removal.substring(0, removal.length() - 1);
        }
        List<String> removels = Arrays.asList(removal.split(","));
        if (null == models) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("datas", "[]");
            map.put("names", "[]");
            map.put("tableName", model.getTableName());
            map.put("keys", keysT == null ? "[]" : gson.toJson((Object)keysT));
            if (keysT == null) {
                return map;
            }
            for (String keyT : keysT) {
                if (removels.contains(keyT.toLowerCase())) continue;
                int index = SortKit.getSort(keyT);
                indexs.add(index);
                sortMap.put(index, keyT);
            }
            indexs.sort(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    if (o1 > o2) {
                        return 1;
                    }
                    return -1;
                }
            });
            Iterator iterator = indexs.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                keysN.add(sortMap.get(i));
                names.add(DictKit.getChinese((String)sortMap.get(i)));
            }
            map.put("names", gson.toJson(names));
            map.put("keys", gson.toJson(keysN));
            return map;
        }
        if (models.size() == 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("datas", "[]");
            map.put("keys", keysT == null ? "[]" : gson.toJson((Object)keysT));
            for (String keyT : keysT) {
                if (removels.contains(keyT.toLowerCase())) continue;
                names.add(DictKit.getChinese(keyT));
                keysN.add(keyT);
            }
            map.put("tableName", model.getTableName());
            map.put("names", gson.toJson(names));
            map.put("keys", gson.toJson(keysN));
            return map;
        }
        List<Map<String, Object>> maps = ModelKit.toMaps(models);
        String jsonArray = gson.toJson(maps);
        ArrayList keys = new ArrayList();
        Map<String, Object> mapT = maps.get(0);
        for (String keyT : mapT.keySet()) {
            String keyTS = keyT.toString();
            if (removels.contains(keyTS.toLowerCase()) || keys.equals(keyT.toString())) continue;
            int index = SortKit.getSort(keyT.toString());
            indexs.add(index);
            sortMap.put(index, keyT.toString());
        }
        indexs.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1 > o2) {
                    return 1;
                }
                return -1;
            }
        });
        Iterator<String> keyT = indexs.iterator();
        while (keyT.hasNext()) {
            int i = (Integer)((Object)keyT.next());
            String nameT = DictKit.getChinese((String)sortMap.get(i));
            keys.add(sortMap.get(i));
            names.add(nameT);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("datas", jsonArray);
        try {
            map.put("tableName", models.get(0).getTableName());
        }
        catch (Exception e) {
            SysKit.print(e);
        }
        map.put("keys", gson.toJson(keys));
        map.put("names", gson.toJson(names));
        return map;
    }

    public static Map toJson(BaseModel<?> model, String removal) {
        return ModelKit.toJson(null, model, removal);
    }

    public static Map toJson(BaseModel<?> model) {
        return ModelKit.toJson(null, model, "");
    }

    public static List<Map<String, Object>> toMaps(List<? extends BaseModel> models) {
        return ModelKit.toMaps(models, false);
    }

    public static List<Map<String, Object>> toMaps(List<? extends BaseModel> models, boolean changeToHump) {
        if (models == null) {
            return null;
        }
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        for (BaseModel baseModel : models) {
            maps.add(ModelKit.toMap(baseModel, changeToHump));
        }
        return maps;
    }

    public static JsonArray toTree(List<? extends BaseModel> models) {
        if (models == null) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (BaseModel baseModel : models) {
            jsonObject = new JsonObject();
            jsonObject.addProperty("id", baseModel.getStr("id"));
            jsonObject.addProperty("title", baseModel.getStr("name"));
            jsonObject.addProperty("code", baseModel.getStr("code"));
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public static JsonArray toTrees(List<? extends BaseModel> listMap) {
        if (listMap == null || listMap.size() == 0) {
            return null;
        }
        List<String> allCode = null;
        allCode = listMap.get(0).getFields();
        for (int i = 0; i < allCode.size(); ++i) {
            if (!allCode.get(i).toString().endsWith("_code")) continue;
            allCode.remove(i);
            --i;
        }
        allCode.remove("bind_code");
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < listMap.size(); ++i) {
            BaseModel baseModel = listMap.get(i);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", baseModel.getStr("id"));
            if (baseModel.get("parent_code") != null && baseModel.get("parent_code").toString().length() >= 2) continue;
            jsonObject.addProperty("title", baseModel.getStr("name"));
            jsonObject.addProperty("code", baseModel.getStr("code"));
            listMap.remove(i);
            --i;
            ArrayList<JsonObject> pCodes = new ArrayList<JsonObject>();
            ArrayList<JsonObject> pCodesT = new ArrayList<JsonObject>();
            pCodes.add(jsonObject);
            boolean isEnd = false;
            while (!isEnd) {
                isEnd = true;
                if (pCodesT.size() > 0) {
                    pCodes.clear();
                    pCodes = pCodesT;
                    pCodesT = new ArrayList();
                }
                for (JsonObject jsonObjectT : pCodes) {
                    JsonArray childArray = new JsonArray();
                    for (int ii = 0; ii < listMap.size(); ++ii) {
                        BaseModel model = listMap.get(ii);
                        if (!model.getStr("parent_code").equals(jsonObjectT.get("code").getAsString())) continue;
                        JsonObject childObject = new JsonObject();
                        childObject.addProperty("id", model.getStr("id"));
                        childObject.addProperty("title", model.getStr("name"));
                        childObject.addProperty("code", model.getStr("code"));
                        for (String code : allCode) {
                            childObject.addProperty(String.valueOf(code), model.getStr(String.valueOf(code)));
                        }
                        childArray.add((JsonElement)childObject);
                        listMap.remove(ii);
                        pCodesT.add(childObject);
                        --ii;
                        isEnd = false;
                    }
                    jsonObjectT.add("children", (JsonElement)childArray);
                }
            }
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public static Map toMap(Model model) {
        return ModelKit.toMap(model, false);
    }

    public static Map<String, Object> toMap(Model model, boolean changeToHump) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> attrs = model._getAttrsEntrySet();
        for (Map.Entry<String, Object> entry : attrs) {
            try {
                if (null == entry.getValue()) continue;
                if (changeToHump) {
                    map.put(ModelKit.changeToHump(entry.getKey()), entry.getValue());
                    continue;
                }
                map.put(entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                map.put(entry.getKey(), "");
            }
        }
        return map;
    }

    public static String changeToHump(String str) {
        if (null == str) {
            return null;
        }
        if (str.contains("_")) {
            String[] strs = str.split("_");
            for (int i = 0; i < strs.length; ++i) {
                if (i == 0) {
                    str = strs[i];
                    continue;
                }
                char[] cs = strs[i].toCharArray();
                cs[0] = (char)(cs[0] - 32);
                str = str + String.valueOf(cs);
            }
        }
        return str;
    }

    public static BaseModel<?> toModel1(BaseModel<?> model, Map<String, String[]> mapData) {
        model.clear();
        HashMap map = new HashMap();
        Set<String> attrs = mapData.keySet();
        for (String entry : attrs) {
            if (null == mapData.get(entry)) continue;
            try {
                model.set(entry, mapData.get(entry)[0]);
            }
            catch (Exception e) {
                model.put(entry, mapData.get(entry)[0]);
            }
        }
        try {
            model.set("modify_time", new Date());
        }
        catch (Exception e) {
            System.out.println("\u6ca1\u6709\u66f4\u65b0\u65f6\u95f4");
        }
        return model;
    }

    public static BaseModel<?> toModel(BaseModel<?> model, Map<String, Object> mapData) {
        model.clear();
        Set<String> attrs = mapData.keySet();
        List<String> fields = model.getFields();
        for (String entry : attrs) {
            if (null == mapData.get(entry)) continue;
            if (fields.contains(entry)) {
                model.set(entry, mapData.get(entry));
                continue;
            }
            model.put(entry, mapData.get(entry));
        }
        try {
            model.set("modify_time", new Date());
        }
        catch (Exception e) {
            System.out.println("\u6ca1\u6709\u66f4\u65b0\u65f6\u95f4");
        }
        return model;
    }

    public static void sort(List<? extends BaseModel> list, final String sortKey, final boolean isBig2Small) {
        ModelKit.removeDuplicate(list);
        try {
            list.sort((Comparator<? extends BaseModel>)new Comparator<BaseModel>(){

                @Override
                public int compare(BaseModel o1, BaseModel o2) {
                    try {
                        Date dt1 = o1.getDate(sortKey);
                        Date dt2 = o2.getDate(sortKey);
                        if (dt1.getTime() < dt2.getTime()) {
                            if (isBig2Small) {
                                return 1;
                            }
                            return -1;
                        }
                        if (dt1.getTime() > dt2.getTime()) {
                            if (isBig2Small) {
                                return -1;
                            }
                            return 1;
                        }
                        return 0;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
        }
        catch (Exception e) {
            SysKit.print(e);
        }
    }

    public static List removeDuplicate(List list) {
        HashSet h = new HashSet(list);
        list.clear();
        list.addAll(h);
        return list;
    }
}

