/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;
import space.yizhu.kits.Base64Kit;
import space.yizhu.kits.SysKit;

public class RedisKit {
    private static RedisTemplate<String, Object> redisTemplate;

    public static void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        RedisKit.redisTemplate = redisTemplate;
    }

    public static boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static long getExpire(String key) {
        return redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public static boolean hasKey(String key) {
        try {
            return redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                redisTemplate.delete((Object)key[0]);
            } else {
                CollectionUtils.arrayToList((Object)key).forEach(item -> redisTemplate.delete((Object)String.valueOf(item)));
            }
        }
    }

    public static Object get(String key) {
        return key == null ? null : redisTemplate.opsForValue().get((Object)key);
    }

    public static boolean set(String key, Object value) {
        try {
            redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean setIfAbsent(String key, Object value) {
        try {
            redisTemplate.opsForValue().setIfAbsent((Object)key, value);
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                RedisKit.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public static long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public static Object hget(String key, String item) {
        return redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public static Map<Object, Object> hmget(String key) {
        return redisTemplate.opsForHash().entries((Object)key);
    }

    public static boolean hmset(String key, Map<String, Object> map) {
        for (Map.Entry<String, Object> st : map.entrySet()) {
            if (null != st.getKey() && null != st.getValue()) continue;
            map.remove(st.getKey());
        }
        try {
            redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            for (Map.Entry<String, Object> st : map.entrySet()) {
                if (null != st.getKey() && null != st.getValue()) continue;
                map.remove(st.getKey());
            }
            redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                RedisKit.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean hset(String key, String item, Object value) {
        try {
            redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean hset(String key, String item, Object value, long time) {
        try {
            redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                RedisKit.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static void hdel(String key, Object ... item) {
        redisTemplate.opsForHash().delete((Object)key, item);
    }

    public static boolean hHasKey(String key, String item) {
        return redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public static double hincr(String key, String item, double by) {
        return redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public static double hdecr(String key, String item, double by) {
        return redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public static Set<Object> sGet(String key) {
        try {
            return redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            SysKit.print(e);
            return null;
        }
    }

    public static boolean sHasKey(String key, Object value) {
        try {
            return redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static long sSet(String key, Object ... values) {
        try {
            return redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            SysKit.print(e);
            return 0L;
        }
    }

    public static long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                RedisKit.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            SysKit.print(e);
            return 0L;
        }
    }

    public static long sGetSetSize(String key) {
        try {
            return redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            SysKit.print(e);
            return 0L;
        }
    }

    public static long setRemove(String key, Object ... values) {
        try {
            Long count = redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            SysKit.print(e);
            return 0L;
        }
    }

    public static List<Object> lGet(String key, long start, long end) {
        try {
            return redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            SysKit.print(e);
            return null;
        }
    }

    public static long lGetListSize(String key) {
        try {
            return redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            SysKit.print(e);
            return 0L;
        }
    }

    public static Object lGetIndex(String key, long index) {
        try {
            return redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            SysKit.print(e);
            return null;
        }
    }

    public static boolean lSet(String key, Object value) {
        try {
            redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean lSet(String key, Object value, long time) {
        try {
            redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                RedisKit.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean lSet(String key, List<Object> value) {
        try {
            redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean lSet(String key, List<Object> value, long time) {
        try {
            redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                RedisKit.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static boolean lUpdateIndex(String key, long index, Object value) {
        try {
            redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            SysKit.print(e);
            return false;
        }
    }

    public static long lRemove(String key, long count, Object value) {
        try {
            Long remove = redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            SysKit.print(e);
            return 0L;
        }
    }

    public static byte[] ser(Object o) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            return baos.toByteArray();
        }
        catch (IOException e) {
            SysKit.print(e);
            return null;
        }
    }

    public static Object unser(byte[] bs) {
        ByteArrayInputStream bais = null;
        bais = new ByteArrayInputStream(bs);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(bais);
            return objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            SysKit.print(e);
            return null;
        }
    }

    public static byte[] serlist(List<?> list) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] bytes = null;
        byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            oos = new ObjectOutputStream(byteArrayOutputStream);
            for (Object o : list) {
                oos.writeObject(o);
            }
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        return bytes;
    }

    public static List<?> unserList(byte[] bytes) {
        ArrayList<Object> list = new ArrayList<Object>();
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        bais = new ByteArrayInputStream(bytes);
        try {
            Object object;
            ois = new ObjectInputStream(bais);
            while (bais.available() > 0 && (object = ois.readObject()) != null) {
                list.add(object);
            }
        }
        catch (IOException e) {
            SysKit.print(e);
        }
        catch (ClassNotFoundException e) {
            SysKit.print(e);
        }
        return list;
    }

    public static <T> T getBean(String key) {
        return (T)RedisKit.unser(Base64Kit.decode(String.valueOf(RedisKit.get(String.valueOf(key)))));
    }
}

