/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import space.yizhu.kits.CharKit;
import space.yizhu.kits.DateKit;

public class SysKit {
    private static String prefix = "\u7cfb\u7edf";
    private static Calendar lastDate = Calendar.getInstance();
    private static ConcurrentHashMap<String, Calendar> timeMap = new ConcurrentHashMap();
    private static String packageName = "space.yizhu";

    public static String getPackageName() {
        return packageName;
    }

    public static void setPackageName(String packageName) {
        SysKit.packageName = packageName;
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getSysInfo(String key) {
        Iterator<MBeanServer> iterator;
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        MBeanServer mBeanServer = null;
        ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
        if (mBeanServers.size() > 0 && (iterator = mBeanServers.iterator()).hasNext()) {
            MBeanServer _mBeanServer;
            mBeanServer = _mBeanServer = iterator.next();
        }
        if (mBeanServer == null) {
            throw new IllegalStateException("\u6ca1\u6709\u53d1\u73b0JVM\u4e2d\u5173\u8054\u7684MBeanServer.");
        }
        Set<ObjectName> objectNames = null;
        try {
            objectNames = mBeanServer.queryNames(new ObjectName("Catalina:type=Connector,*"), null);
        }
        catch (MalformedObjectNameException e) {
            SysKit.print(e);
        }
        catch (NullPointerException e) {
            SysKit.print(e);
        }
        if (objectNames == null || objectNames.size() <= 0) {
            throw new IllegalStateException("\u6ca1\u6709\u53d1\u73b0JVM\u4e2d\u5173\u8054\u7684MBeanServer : " + mBeanServer.getDefaultDomain() + " \u4e2d\u7684\u5bf9\u8c61\u540d\u79f0.");
        }
        try {
            for (ObjectName objectName : objectNames) {
                String protocol = (String)mBeanServer.getAttribute(objectName, "protocol");
                if (!protocol.equals("HTTP/1.1")) continue;
                int n = (Integer)mBeanServer.getAttribute(objectName, "port");
            }
        }
        catch (AttributeNotFoundException e) {
            SysKit.print(e);
        }
        catch (InstanceNotFoundException e) {
            SysKit.print(e);
        }
        catch (MBeanException e) {
            SysKit.print(e);
        }
        catch (ReflectionException e) {
            SysKit.print(e);
        }
        return null;
    }

    public static void print() {
        System.out.println(DateKit.now() + " - [" + prefix + "]: ----------------------------  " + SysKit.take());
    }

    public static void print(String msg) {
        if (msg == null) {
            return;
        }
        if (msg.length() > 1) {
            if (msg.contains("br")) {
                System.out.println(DateKit.now() + " - [" + prefix + "]:" + msg.substring(0, msg.indexOf("br")) + SysKit.take());
            } else {
                System.out.println(DateKit.now() + " - [" + prefix + "]:" + msg + SysKit.take());
            }
        }
    }

    public static void print(String msg, String lab) {
        if (lab == null || lab.length() == 0) {
            SysKit.print(msg);
            return;
        }
        if ((lab = lab.toLowerCase()).contains("test")) {
            SysKit.print(msg);
        } else if (null == timeMap.get(lab)) {
            if (Calendar.getInstance().get(5) != lastDate.get(5)) {
                timeMap.clear();
            }
            if (!lab.startsWith("self")) {
                System.out.println(DateKit.now() + " - [" + lab + "]:" + msg + " - \u5f00\u59cb\u8ba1\u65f6 ------");
            }
            timeMap.put(lab, Calendar.getInstance());
        } else {
            System.out.println(DateKit.now() + " - [" + lab + "]:" + msg + " - \u7ed3\u675f\u8ba1\u65f6," + SysKit.take(timeMap.get(lab)));
            timeMap.remove(lab);
            if (Calendar.getInstance().get(5) != lastDate.get(5)) {
                timeMap.clear();
            }
        }
    }

    public static void print(String msg, String lab, boolean isStart) {
        if (isStart) {
            timeMap.remove(lab);
            SysKit.print(msg, lab);
        }
    }

    private static String take(Calendar lastDateT) {
        if (lastDateT == null) {
            lastDateT = Calendar.getInstance();
        }
        String prefix = " - \u7528\u65f6:";
        long n = Calendar.getInstance().getTimeInMillis();
        long range = n - lastDateT.getTimeInMillis();
        lastDate = Calendar.getInstance();
        if (range > 1036800000L) {
            return prefix + CharKit.doubleKeepDecimal((double)range / 1.0368E9) + "\u5e74";
        }
        if (range > 86400000L) {
            return prefix + CharKit.doubleKeepDecimal((double)range / 8.64E7) + "\u5929";
        }
        if (range > 3600000L) {
            return prefix + CharKit.doubleKeepDecimal((double)range / 3600000.0) + "\u5c0f\u65f6";
        }
        if (range > 60000L) {
            return prefix + CharKit.doubleKeepDecimal((double)range / 60000.0) + "\u5206\u949f";
        }
        if (range > 1000L) {
            return prefix + CharKit.doubleKeepDecimal((double)range / 1000.0) + "\u79d2";
        }
        if (range < 1000L) {
            return prefix + CharKit.doubleKeepDecimal((double)range / 1.0) + "\u6beb\u79d2";
        }
        return prefix + CharKit.doubleKeepDecimal((double)range / 1.0) + "\u6beb\u79d2";
    }

    public static String take(String lab) {
        lab = lab.toLowerCase();
        return SysKit.take(timeMap.get(lab));
    }

    public static void print(Exception msg) {
        SysKit.err(msg);
    }

    public static void print(Throwable msg) {
        SysKit.err(msg);
    }

    private static void err(Throwable msg) {
        msg.printStackTrace();
        try {
            if (SysKit.getPackageName() != null) {
                for (StackTraceElement traceElement : msg.getStackTrace()) {
                    if (!traceElement.getClassName().contains(SysKit.getPackageName())) continue;
                    System.err.println(DateKit.now() + " - [" + traceElement.getClassName() + traceElement.getLineNumber() + "]:" + msg.toString() + SysKit.take());
                }
            } else {
                System.err.println(DateKit.now() + " - [" + msg.getStackTrace()[0].getMethodName() + msg.getStackTrace()[0].getLineNumber() + "]:" + msg.toString() + SysKit.take());
            }
        }
        catch (Exception e) {
            SysKit.print(e);
            System.err.println(DateKit.now() + msg.getLocalizedMessage() + SysKit.take());
        }
    }

    public static void print(Throwable msg, String prefix) {
        try {
            System.err.println(DateKit.now() + " - [" + prefix + "]:" + msg.getLocalizedMessage() + SysKit.take());
        }
        catch (Exception e) {
            SysKit.print(e);
        }
    }

    public static void print(Exception msg, String prefix) {
        try {
            System.err.println(DateKit.now() + " - [" + prefix + "]:" + (msg.getLocalizedMessage() == null ? msg.getMessage() : msg.getLocalizedMessage()) + SysKit.take());
        }
        catch (Exception e) {
            SysKit.print(e);
        }
    }

    public static void print(int num) {
        System.err.println(DateKit.now() + " - [" + prefix + "]:" + num + SysKit.take());
    }

    private static String take() {
        return SysKit.take(lastDate);
    }

    public static void main(String[] args) {
        String str = null;
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            SysKit.print(e);
        }
        SysKit.print("hh");
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SysKit.print("12");
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        SysKit.prefix = prefix;
    }
}

