/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.kits;

import com.alibaba.druid.support.json.JSONUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ToolKit {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static String numberString = "0123456789";

    public static String getRandomCode() {
        Random rand = new Random();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            result.append(rand.nextInt(10));
        }
        return result.toString();
    }

    public static int getRandomInt(int max, int min) {
        Random random = new Random();
        if (max - min < 2) {
            return max;
        }
        if (max > min) {
            return random.nextInt(max) % (max - min + 1) + min;
        }
        return random.nextInt(min + 1) % (min - max + 1) + max;
    }

    public static double getRandomInt(double max, double min) {
        int maxI = Double.valueOf(max *= 100.0).intValue();
        int minI = Double.valueOf(min *= 100.0).intValue();
        Random random = new Random();
        if (max > min) {
            return (double)(random.nextInt(maxI) % (maxI - minI + 1) + minI) / 100.0;
        }
        return (double)(random.nextInt(minI) % (minI - maxI + 1) + maxI) / 100.0;
    }

    public static double getRandomDouble() {
        Random random = new Random();
        return random.nextDouble();
    }

    public static String getStringRandom(int length) {
        StringBuilder val = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val.append((char)(random.nextInt(26) + temp));
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val.append(String.valueOf(random.nextInt(10)));
        }
        return val.toString().toLowerCase();
    }

    public static String getToken(String device, Integer userid) {
        return ToolKit.toMd5(device + userid + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
    }

    public static String getSaveName(Date date, String fileName, int num) {
        return DateFormatUtils.format((Date)date, (String)"yyyyMMddHHmmssSSS") + "_" + num + "." + fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String toMd5(String text) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support MD5 algorithm.");
        }
        try {
            msgDigest.update(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("System doesn't support your  EncodingException.");
        }
        byte[] bytes = msgDigest.digest();
        String md5Str = new String(ToolKit.encodeHex(bytes));
        return md5Str;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }

    public static byte[] decode2Hex(String nm) {
        int len = nm.length();
        byte[] result = new byte[len / 2];
        for (int i = 0; i < len; ++i) {
            char c = nm.charAt(i);
            byte b = Byte.decode("0x" + c);
            c = nm.charAt(++i);
            result[i / 2] = (byte)(b << 4 | Byte.decode("0x" + c));
        }
        return result;
    }

    public static String bytes2HexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static float toFixed(float f, Integer len) {
        Long mup = new Double(Math.pow(10.0, len.intValue())).longValue();
        return (float)Math.round(f * (float)mup.longValue()) / mup.floatValue();
    }

    public static String array2String(String[] ary, String split) {
        if (ary == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ary.length; ++i) {
            sb.append(ary[i]);
            if (i == ary.length - 1) continue;
            sb.append(split);
        }
        return sb.toString();
    }

    public static String uNull(String object) {
        return object == null ? "" : object;
    }

    public static String getUUID() {
        UUID id = UUID.randomUUID();
        String idStr = id.toString();
        idStr = idStr.replaceAll("-", "");
        return idStr;
    }

    public static String getCaptcha(int len) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int random = new Random().nextInt(numberString.length());
            char chr = numberString.charAt(random);
            str.append(chr);
        }
        return str.toString();
    }

    public static String maskingPhone(String phone) {
        int len = phone.length() - 5;
        StringBuilder mask = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            mask.append("*");
        }
        return phone.substring(0, 3) + mask + phone.substring(phone.length() - 2);
    }

    public static String maskingEmail(String email) {
        int len = email.indexOf(64) - 2;
        String mask = "";
        for (int i = 0; i < len; ++i) {
            mask = mask + "*";
        }
        return email.substring(0, 2) + mask + email.substring(email.indexOf(64));
    }

    public static String addSqlStr(String str) {
        if (str.contains("'")) {
            return str;
        }
        String strD = null;
        if (str.contains(",")) {
            if (str.endsWith(",")) {
                str = str.substring(0, str.length() - 1);
                String str1 = str.replace(",", "','");
                strD = "'" + str1 + "'";
                return strD;
            }
            String str1 = str.replace(",", "','");
            strD = "'" + str1 + "'";
            return strD;
        }
        strD = "'" + str + "'";
        return strD;
    }

    public static String doubleKeepDecimal(Double str) {
        DecimalFormat df = new DecimalFormat("#0.00");
        return df.format(str);
    }

    public static Map<String, List<String>> splitSpecial(String formala) {
        HashMap<String, List<String>> varAndSpecial = new HashMap<String, List<String>>();
        ArrayList<String> vars = new ArrayList<String>();
        ArrayList<String> specials = new ArrayList<String>();
        int upnext = 0;
        for (int i = 0; i < formala.length(); ++i) {
            if (ToolKit.isSpecialString(formala.substring(i, i + 1))) {
                vars.add(formala.substring(upnext, i));
                specials.add(formala.substring(i, i + 1));
                upnext = i + 1;
            }
            if (i != formala.length() - 1 || upnext > i) continue;
            vars.add(formala.substring(upnext, i + 1));
        }
        varAndSpecial.put("vars", vars);
        varAndSpecial.put("specials", specials);
        return varAndSpecial;
    }

    public static Object getObject(Object obj) {
        return obj == null ? "null" : obj;
    }

    public static boolean isSpecialString(String str) {
        String regEx = "[ _`~!@#$%^&*()+\\-=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static String jsonToStr(Object obj) {
        String json = "";
        try {
            json = JSONUtils.toJSONString((Object)obj);
        }
        catch (Exception e) {
            System.out.println("mapToJson\u5931\u8d25:" + e.getLocalizedMessage());
        }
        return json;
    }

    public static String mapToJson(Map map) {
        String json = "";
        try {
            json = JSONUtils.toJSONString((Object)map);
        }
        catch (Exception e) {
            System.out.println("mapToJson\u5931\u8d25:" + e.getLocalizedMessage());
        }
        return json;
    }

    public static String listToJson(List list) {
        String json = "";
        try {
            json = JSONUtils.toJSONString((Object)list);
        }
        catch (Exception e) {
            System.out.println("listToJson:" + e.getLocalizedMessage());
        }
        return json;
    }

    public static String toJson(Object obj) {
        String json = "";
        try {
            json = JSONUtils.toJSONString((Object)obj);
        }
        catch (Exception e) {
            System.out.println("listToJson:" + e.getLocalizedMessage());
        }
        return json;
    }

    public static Object[][] to2Array(Object[] oneArry) {
        Object[][] arr = new Object[1][oneArry.length];
        System.arraycopy(oneArry, 0, arr[0], 0, oneArry.length);
        return arr;
    }

    public static Object mapToBean(Map map, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (map == null || map.size() == 0) {
            return null;
        }
        Object obj = beanClass.newInstance();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            Object val = map.get(field.getName());
            if (null == val) continue;
            if (null != field.get(obj)) {
                if (field.getType() == String.class) {
                    field.set(obj, String.valueOf(map.get(field.getName())));
                    continue;
                }
                if (field.get(obj) instanceof Number) {
                    if (field.get(obj) instanceof Integer) {
                        field.set(obj, Integer.valueOf(String.valueOf(map.get(field.getName()))));
                        continue;
                    }
                    if (field.get(obj) instanceof Double) {
                        field.set(obj, Double.valueOf(String.valueOf(map.get(field.getName()))));
                        continue;
                    }
                    if (field.get(obj) instanceof Float) {
                        field.set(obj, Float.valueOf(String.valueOf(map.get(field.getName()))));
                        continue;
                    }
                    if (field.get(obj) instanceof Long) {
                        field.set(obj, Long.valueOf(String.valueOf(map.get(field.getName()))));
                        continue;
                    }
                    if (field.get(obj) instanceof Short) {
                        field.set(obj, Short.valueOf(String.valueOf(map.get(field.getName()))));
                        continue;
                    }
                    if (!(field.get(obj) instanceof Byte)) continue;
                    field.set(obj, Byte.valueOf(String.valueOf(map.get(field.getName()))));
                    continue;
                }
                field.set(obj, map.get(field.getName()));
                continue;
            }
            if (field.getType() == String.class) {
                field.set(obj, String.valueOf(map.get(field.getName())));
                continue;
            }
            field.set(obj, map.get(field.getName()));
        }
        return obj;
    }

    public static Map beanToMap(Object obj) throws Exception {
        Field[] fields;
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            if (null == field.get(obj)) continue;
            map.put(field.getName(), field.get(obj));
        }
        return map;
    }
}

