/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.aop;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import space.yizhu.record.aop.Enhance;
import space.yizhu.record.aop.Inject;
import space.yizhu.record.aop.Singleton;

public class AopFactory {
    protected ConcurrentHashMap<Class<?>, Object> singletonCache = new ConcurrentHashMap();
    protected HashMap<Class<?>, Class<?>> mapping = null;
    protected static int MAX_INJECT_DEPTH = 7;
    protected boolean singleton = true;
    protected boolean enhance = true;
    protected int injectDepth = 3;

    public <T> T get(Class<T> targetClass) {
        try {
            return this.doGet(targetClass, this.injectDepth);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T get(Class<T> targetClass, int injectDepth) {
        try {
            return this.doGet(targetClass, injectDepth);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doGet(Class<T> targetClass, int injectDepth) throws ReflectiveOperationException {
        boolean singleton;
        Singleton si = (targetClass = this.getMappingClass(targetClass)).getAnnotation(Singleton.class);
        boolean bl = singleton = si != null ? si.value() : this.singleton;
        if (!singleton) {
            Object ret = this.createObject(targetClass);
            this.doInject(targetClass, ret, injectDepth);
            return (T)ret;
        }
        Object ret = this.singletonCache.get(targetClass);
        if (ret == null) {
            AopFactory aopFactory = this;
            synchronized (aopFactory) {
                ret = this.singletonCache.get(targetClass);
                if (ret == null) {
                    ret = this.createObject(targetClass);
                    this.doInject(targetClass, ret, injectDepth);
                    this.singletonCache.put(targetClass, ret);
                }
            }
        }
        return (T)ret;
    }

    public <T> T inject(T targetObject) {
        try {
            this.doInject(targetObject.getClass(), targetObject, this.injectDepth);
            return targetObject;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T inject(T targetObject, int injectDepth) {
        try {
            this.doInject(targetObject.getClass(), targetObject, injectDepth);
            return targetObject;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T inject(Class<T> targetClass, T targetObject) {
        try {
            this.doInject(targetClass, targetObject, this.injectDepth);
            return targetObject;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T inject(Class<T> targetClass, T targetObject, int injectDepth) {
        try {
            this.doInject(targetClass, targetObject, injectDepth);
            return targetObject;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doInject(Class<?> targetClass, Object targetObject, int injectDepth) throws ReflectiveOperationException {
        if (injectDepth-- <= 0) {
            return;
        }
        Field[] fields = (targetClass = this.getUsefulClass(targetClass)).getDeclaredFields();
        if (fields.length == 0) {
            return;
        }
        for (Field field : fields) {
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            Class<?> fieldInjectedClass = inject.value();
            if (fieldInjectedClass == Void.class) {
                fieldInjectedClass = field.getType();
            }
            Object fieldInjectedObject = this.doGet(fieldInjectedClass, injectDepth);
            field.setAccessible(true);
            field.set(targetObject, fieldInjectedObject);
        }
    }

    protected Object createObject(Class<?> targetClass) throws ReflectiveOperationException {
        Enhance en = targetClass.getAnnotation(Enhance.class);
        boolean enhance = en != null ? en.value() : this.enhance;
        return targetClass.newInstance();
    }

    protected Class<?> getUsefulClass(Class<?> clazz) {
        return clazz.getName().indexOf("$$EnhancerBy") == -1 ? clazz : clazz.getSuperclass();
    }

    @Deprecated
    public AopFactory setEnhance(boolean enhance) {
        this.enhance = enhance;
        return this;
    }

    public AopFactory setSingleton(boolean singleton) {
        this.singleton = singleton;
        return this;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public AopFactory setInjectDepth(int injectDepth) {
        if (injectDepth <= 0) {
            throw new IllegalArgumentException("\u6ce8\u5165\u5c42\u6570\u5fc5\u987b\u5927\u4e8e 0");
        }
        if (injectDepth > MAX_INJECT_DEPTH) {
            throw new IllegalArgumentException("\u4e3a\u4fdd\u969c\u6027\u80fd\uff0c\u6ce8\u5165\u5c42\u6570\u4e0d\u80fd\u8d85\u8fc7 " + MAX_INJECT_DEPTH);
        }
        this.injectDepth = injectDepth;
        return this;
    }

    public int getInjectDepth() {
        return this.injectDepth;
    }

    public AopFactory addSingletonObject(Object singletonObject) {
        if (singletonObject == null) {
            throw new IllegalArgumentException("singletonObject can not be null");
        }
        if (singletonObject instanceof Class) {
            throw new IllegalArgumentException("singletonObject can not be Class type");
        }
        Class<?> type = this.getUsefulClass(singletonObject.getClass());
        if (this.singletonCache.putIfAbsent(type, singletonObject) != null) {
            throw new RuntimeException("Singleton object already exists for type : " + type.getName());
        }
        return this;
    }

    public synchronized <T> AopFactory addMapping(Class<T> from, Class<? extends T> to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("The parameter from and to can not be null");
        }
        if (this.mapping == null) {
            this.mapping = new HashMap(128, 0.25f);
        } else if (this.mapping.containsKey(from)) {
            throw new RuntimeException("Class already mapped : " + from.getName());
        }
        this.mapping.put(from, to);
        return this;
    }

    public <T> AopFactory addMapping(Class<T> from, String to) {
        try {
            Class<?> toClass = Class.forName(to.trim());
            if (from.isAssignableFrom(toClass)) {
                return this.addMapping(from, toClass);
            }
            throw new IllegalArgumentException("The parameter \"to\" must be the subclass or implementation of the parameter \"from\"");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getMappingClass(Class<?> from) {
        if (this.mapping != null) {
            Class<?> ret = this.mapping.get(from);
            return ret != null ? ret : from;
        }
        return from;
    }
}

