/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.log;

import space.yizhu.record.log.ILogFactory;

public abstract class Log {
    private static ILogFactory defaultLogFactory = null;

    static void init() {
        if (defaultLogFactory == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                Class<?> log4jLogFactoryClass = Class.forName("space.yizhu.record.log.Log4jLogFactory");
                defaultLogFactory = (ILogFactory)log4jLogFactoryClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void setDefaultLogFactory(ILogFactory defaultLogFactory) {
        if (defaultLogFactory == null) {
            throw new IllegalArgumentException("defaultLogFactory can not be null.");
        }
        Log.defaultLogFactory = defaultLogFactory;
    }

    public static Log getLog(Class<?> clazz) {
        return defaultLogFactory.getLog(clazz);
    }

    public static Log getLog(String name) {
        return defaultLogFactory.getLog(name);
    }

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract void fatal(String var1);

    public abstract void fatal(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    static {
        Log.init();
    }
}

