/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.plugin.activerecord;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import space.yizhu.record.plugin.activerecord.IContainerFactory;

public class CaseInsensitiveContainerFactory
implements IContainerFactory {
    private static Boolean toLowerCase = null;

    public CaseInsensitiveContainerFactory() {
    }

    public CaseInsensitiveContainerFactory(boolean toLowerCase) {
        CaseInsensitiveContainerFactory.toLowerCase = toLowerCase;
    }

    @Override
    public Map<String, Object> getAttrsMap() {
        return new CaseInsensitiveMap<Object>();
    }

    @Override
    public Map<String, Object> getColumnsMap() {
        return new CaseInsensitiveMap<Object>();
    }

    @Override
    public Set<String> getModifyFlagSet() {
        return new CaseInsensitiveSet();
    }

    private static String convertCase(String key) {
        if (toLowerCase != null) {
            return toLowerCase != false ? key.toLowerCase() : key.toUpperCase();
        }
        return key;
    }

    public static class CaseInsensitiveMap<V>
    extends TreeMap<String, V> {
        private static final long serialVersionUID = 7482853823611007217L;

        public CaseInsensitiveMap() {
            super(String.CASE_INSENSITIVE_ORDER);
        }

        @Override
        public V put(String key, V value) {
            return super.put(CaseInsensitiveContainerFactory.convertCase(key), value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends V> map) {
            for (Map.Entry<String, V> e : map.entrySet()) {
                super.put(CaseInsensitiveContainerFactory.convertCase(e.getKey()), e.getValue());
            }
        }
    }

    public static class CaseInsensitiveSet
    extends TreeSet<String> {
        private static final long serialVersionUID = 6236541338642353211L;

        public CaseInsensitiveSet() {
            super(String.CASE_INSENSITIVE_ORDER);
        }

        @Override
        public boolean add(String e) {
            return super.add(CaseInsensitiveContainerFactory.convertCase(e));
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            boolean modified = false;
            for (String string : c) {
                if (!super.add(CaseInsensitiveContainerFactory.convertCase(string))) continue;
                modified = true;
            }
            return modified;
        }
    }
}

