/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.plugin.activerecord;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import space.yizhu.record.plugin.activerecord.ActiveRecordException;
import space.yizhu.record.plugin.activerecord.Config;
import space.yizhu.record.plugin.activerecord.Db;
import space.yizhu.record.plugin.activerecord.Model;

public final class DbConfig {
    static Config config = null;
    static Config brokenConfig = Config.createBrokenConfig();
    private static Map<Class<? extends Model>, Config> modelToConfig = new HashMap<Class<? extends Model>, Config>(512, 0.5f);
    private static Map<String, Config> configNameToConfig = new HashMap<String, Config>(32, 0.25f);
    static final Object[] NULL_PARA_ARRAY = new Object[0];
    public static final String MAIN_CONFIG_NAME = "main";
    public static final int DEFAULT_TRANSACTION_LEVEL = 4;

    private DbConfig() {
    }

    public static void addConfig(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Config can not be null");
        }
        if (configNameToConfig.containsKey(config.getName())) {
            throw new IllegalArgumentException("Config already exists: " + config.getName());
        }
        configNameToConfig.put(config.getName(), config);
        if (MAIN_CONFIG_NAME.equals(config.getName())) {
            DbConfig.config = config;
            Db.init(DbConfig.config.getName());
        }
        if (DbConfig.config == null) {
            DbConfig.config = config;
            Db.init(DbConfig.config.getName());
        }
    }

    public static Config removeConfig(String configName) {
        if (config != null && config.getName().equals(configName)) {
            config = null;
        }
        Db.removeDbProWithConfig(configName);
        return configNameToConfig.remove(configName);
    }

    static void addModelToConfigMapping(Class<? extends Model> modelClass, Config config) {
        modelToConfig.put(modelClass, config);
    }

    public static Config getConfig() {
        return config;
    }

    public static Config getConfig(String configName) {
        return configNameToConfig.get(configName);
    }

    public static Config getConfig(Class<? extends Model> modelClass) {
        return modelToConfig.get(modelClass);
    }

    static final void close(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    static final void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    public static Set<Map.Entry<String, Config>> getConfigSet() {
        return configNameToConfig.entrySet();
    }

    public static Class<? extends Model> getUsefulClass(Class<? extends Model> modelClass) {
        return modelClass.getName().indexOf("$$EnhancerBy") == -1 ? modelClass : modelClass.getSuperclass();
    }
}

