/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.plugin.activerecord;

import com.google.gson.Gson;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import space.yizhu.bean.LogModel;
import space.yizhu.kits.CharKit;
import space.yizhu.kits.DateKit;
import space.yizhu.kits.DbKit;
import space.yizhu.kits.SysKit;
import space.yizhu.kits.ToolKit;
import space.yizhu.record.plugin.activerecord.ActiveRecordException;
import space.yizhu.record.plugin.activerecord.Config;
import space.yizhu.record.plugin.activerecord.DaoContainerFactory;
import space.yizhu.record.plugin.activerecord.Db;
import space.yizhu.record.plugin.activerecord.DbConfig;
import space.yizhu.record.plugin.activerecord.Page;
import space.yizhu.record.plugin.activerecord.PageSqlKit;
import space.yizhu.record.plugin.activerecord.Record;
import space.yizhu.record.plugin.activerecord.SqlPara;
import space.yizhu.record.plugin.activerecord.Table;
import space.yizhu.record.plugin.activerecord.TableMapping;
import space.yizhu.record.plugin.activerecord.cache.ICache;

public abstract class Model<M extends Model>
implements Serializable {
    public static final int FILTER_BY_SAVE = 0;
    public static final int FILTER_BY_UPDATE = 1;
    private static final long serialVersionUID = -990334519496260591L;
    private String configName;
    private Set<String> modifyFlag;
    private Map<String, Object> attrs = this.createAttrsMap();
    private int pageSize = 30;
    private final String SPACE = " ";
    private long id;
    private String code;
    private String name;
    private String creator;
    private String mender;
    private boolean is_del;
    private Date create_time;
    private Date modify_time;

    private Map<String, Object> createAttrsMap() {
        Config config = this._getConfig();
        if (config == null) {
            return DbConfig.brokenConfig.containerFactory.getAttrsMap();
        }
        return config.containerFactory.getAttrsMap();
    }

    public M dao() {
        this.attrs = DaoContainerFactory.daoMap;
        this.modifyFlag = DaoContainerFactory.daoSet;
        return (M)this;
    }

    protected void filter(int filterBy) {
    }

    protected Map<String, Object> _getAttrs() {
        return this.attrs;
    }

    public Set<Map.Entry<String, Object>> _getAttrsEntrySet() {
        return this.attrs.entrySet();
    }

    public String[] _getAttrNames() {
        Set<String> attrNameSet = this.attrs.keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] _getAttrValues() {
        Collection<Object> attrValueCollection = this.attrs.values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    public M _setAttrs(M model) {
        return this._setAttrs(((Model)model)._getAttrs());
    }

    public M _setAttrs(Map<String, Object> attrs) {
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            this.set(e.getKey(), e.getValue());
        }
        return (M)this;
    }

    protected Set<String> _getModifyFlag() {
        if (this.modifyFlag == null) {
            Config config = this._getConfig();
            this.modifyFlag = config == null ? DbConfig.brokenConfig.containerFactory.getModifyFlagSet() : config.containerFactory.getModifyFlagSet();
        }
        return this.modifyFlag;
    }

    protected Config _getConfig() {
        if (this.configName != null) {
            return DbConfig.getConfig(this.configName);
        }
        return DbConfig.getConfig(this._getUsefulClass());
    }

    protected Table _getTable() {
        return TableMapping.me().getTable(this._getUsefulClass());
    }

    protected Class<? extends Model> _getUsefulClass() {
        Class<?> c = this.getClass();
        return c.getName().indexOf("$$EnhancerBy") == -1 ? c : c.getSuperclass();
    }

    public M use(String configName) {
        if (this.attrs == DaoContainerFactory.daoMap) {
            throw new RuntimeException("dao \u53ea\u5141\u8bb8\u8c03\u7528\u67e5\u8be2\u65b9\u6cd5");
        }
        this.configName = configName;
        return (M)this;
    }

    public M set(String attr, Object value) {
        Table table = this._getTable();
        if (table != null && !table.hasColumnLabel(attr)) {
            throw new ActiveRecordException("The attribute name does not exist: \"" + attr + "\"");
        }
        if (value instanceof String) {
            this.attrs.put(attr, ((String)value).replaceAll("['\"\\\\]", "\\\\$0"));
        } else {
            this.attrs.put(attr, value);
        }
        this._getModifyFlag().add(attr);
        return (M)this;
    }

    public M put(String key, Object value) {
        this.attrs.put(key, value);
        return (M)this;
    }

    public M setOrPut(String attrOrNot, Object value) {
        Table table = this._getTable();
        if (table != null && table.hasColumnLabel(attrOrNot)) {
            this._getModifyFlag().add(attrOrNot);
        }
        this.attrs.put(attrOrNot, value);
        return (M)this;
    }

    public M _setOrPut(Map<String, Object> map) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            this.setOrPut(e.getKey(), e.getValue());
        }
        return (M)this;
    }

    public M _setOrPut(Model model) {
        return this._setOrPut(model._getAttrs());
    }

    public M put(Map<String, Object> map) {
        this.attrs.putAll(map);
        return (M)this;
    }

    public M put(Model model) {
        this.attrs.putAll(model._getAttrs());
        return (M)this;
    }

    public M put(Record record) {
        this.attrs.putAll(record.getColumns());
        return (M)this;
    }

    public Record toRecord() {
        return new Record().setColumns(this._getAttrs());
    }

    public <T> T get(String attr) {
        return (T)this.attrs.get(attr);
    }

    public <T> T get(String attr, Object defaultValue) {
        Object result = this.attrs.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    public String getStr(String attr) {
        Object s = this.attrs.get(attr);
        if (null == s) {
            s = this.attrs.get(attr.toLowerCase());
            if (null == s) {
                return "";
            }
            return s.toString();
        }
        return s.toString();
    }

    public Integer getInt(String attr) {
        Object n = this.attrs.get(attr);
        if (n instanceof Number) {
            return n != null ? ((Number)n).intValue() : -1;
        }
        if (n instanceof String) {
            return n != null ? Integer.parseInt(n.toString()) : -1;
        }
        return -1;
    }

    public Long getLong(String attr) {
        Object n = this.attrs.get(attr);
        if (n instanceof Number) {
            return n != null ? ((Number)n).longValue() : -1L;
        }
        if (n instanceof String) {
            return n != null ? Long.parseLong(n.toString()) : -1L;
        }
        return -1L;
    }

    public BigInteger getBigInteger(String attr) {
        return (BigInteger)this.attrs.get(attr);
    }

    public Date getDate(String attr) {
        Object obj = this.attrs.get(attr);
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof String) {
            return DateKit.parseDate((String)obj);
        }
        if (obj instanceof Number) {
            return new Date(((Number)obj).longValue());
        }
        return null;
    }

    public Time getTime(String attr) {
        return (Time)this.attrs.get(attr);
    }

    public Timestamp getTimestamp(String attr) {
        return (Timestamp)this.attrs.get(attr);
    }

    public Double getDouble(String attr) {
        Number n = (Number)this.attrs.get(attr);
        return n != null ? Double.valueOf(n.doubleValue()) : null;
    }

    public Float getFloat(String attr) {
        Number n = (Number)this.attrs.get(attr);
        return n != null ? Float.valueOf(n.floatValue()) : null;
    }

    public Short getShort(String attr) {
        Number n = (Number)this.attrs.get(attr);
        return n != null ? Short.valueOf(n.shortValue()) : null;
    }

    public Byte getByte(String attr) {
        Number n = (Number)this.attrs.get(attr);
        return n != null ? Byte.valueOf(n.byteValue()) : null;
    }

    public Boolean getBoolean(String attr) {
        return (Boolean)this.attrs.get(attr);
    }

    public BigDecimal getBigDecimal(String attr) {
        return (BigDecimal)this.attrs.get(attr);
    }

    public byte[] getBytes(String attr) {
        return (byte[])this.attrs.get(attr);
    }

    public Number getNumber(String attr) {
        return (Number)this.attrs.get(attr);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginate(pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginate(pageNumber, pageSize, null, select, sqlExceptSelect, DbConfig.NULL_PARA_ARRAY);
    }

    public Page<M> paginate(int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    private Page<M> doPaginate(int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        Config config = this._getConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            String totalRowSql = "select count(*) " + config.dialect.replaceOrderBy(sqlExceptSelect);
            StringBuilder findSql = new StringBuilder();
            findSql.append(select).append(' ').append(sqlExceptSelect);
            Page<M> page = this.doPaginateByFullSql(config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    private Page<M> doPaginateByFullSql(Config config, Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws Exception {
        long totalRow;
        if (pageNumber < 1 || pageSize < 1) {
            throw new ActiveRecordException("pageNumber and pageSize must more than 0");
        }
        if (config.dialect.isTakeOverModelPaginate()) {
            return config.dialect.takeOverModelPaginate(conn, this._getUsefulClass(), pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        List result = Db.query(config, conn, totalRowSql, paras);
        int size = result.size();
        if (isGroupBySql == null) {
            isGroupBySql = size > 1;
        }
        if (isGroupBySql.booleanValue()) {
            totalRow = size;
        } else {
            long l = totalRow = size > 0 ? ((Number)result.get(0)).longValue() : 0L;
        }
        if (totalRow == 0L) {
            return new Page(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        int totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        if (pageNumber > totalPage) {
            return new Page(new ArrayList(0), pageNumber, pageSize, totalPage, (int)totalRow);
        }
        String sql = config.dialect.forPaginate(pageNumber, pageSize, findSql);
        List<M> list = this.find(config, conn, sql, paras);
        return new Page<M>(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    private Page<M> doPaginateByFullSql(int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        Config config = this._getConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            StringBuilder findSqlBuf = new StringBuilder().append(findSql);
            Page<M> page = this.doPaginateByFullSql(config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSqlBuf, paras);
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    public Page<M> paginateByFullSql(int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(pageNumber, pageSize, null, totalRowSql, findSql, paras);
    }

    public Page<M> paginateByFullSql(int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    /*
     * WARNING - void declaration
     */
    public boolean save() {
        StringBuilder sql = new StringBuilder();
        try {
            this.filter(0);
            Config config = this._getConfig();
            Table table = this._getTable();
            ArrayList paras = new ArrayList();
            ArrayList<Object> parasT = new ArrayList<Object>();
            for (Object e : paras) {
                if (e.toString().contains("-")) {
                    parasT.add((Timestamp)e);
                    continue;
                }
                parasT.add(e);
            }
            for (Map.Entry entry : this.attrs.entrySet()) {
                if (entry.getValue() == null) continue;
                if (table.getColumnType((String)entry.getKey()) == Long.class) {
                    entry.setValue(Long.parseLong(String.valueOf(entry.getValue())));
                    continue;
                }
                if (table.getColumnType((String)entry.getKey()) == Integer.class) {
                    if (entry.getValue().toString().equals("")) continue;
                    entry.setValue(Integer.parseInt(String.valueOf(entry.getValue())));
                    continue;
                }
                if (table.getColumnType((String)entry.getKey()) != Timestamp.class) continue;
                if (entry.getValue() instanceof Date) {
                    entry.setValue(new Timestamp(((Date)entry.getValue()).getTime()));
                    continue;
                }
                if (entry.getValue() instanceof String) {
                    entry.setValue(new Timestamp(DateKit.parseDate(entry.getValue().toString()).getTime()));
                    continue;
                }
                if (!(entry.getValue() instanceof Number)) continue;
                entry.setValue(new Timestamp((Long)entry.getValue()));
            }
            config.dialect.forModelSave(table, this.attrs, sql, parasT);
            Connection conn = null;
            Statement statement = null;
            int result = 0;
            try {
                void var7_14;
                conn = config.getConnection();
                if (config.dialect.isOracle()) {
                    PreparedStatement preparedStatement = conn.prepareStatement(sql.toString(), table.getPrimaryKey());
                } else {
                    PreparedStatement preparedStatement = conn.prepareStatement(sql.toString(), 1);
                }
                config.dialect.fillStatement((PreparedStatement)var7_14, parasT);
                result = var7_14.executeUpdate();
                config.dialect.getModelGeneratedKey(this, (PreparedStatement)var7_14, table);
                this._getModifyFlag().clear();
                config.close((Statement)var7_14, conn);
            }
            catch (Exception e) {
                try {
                    throw new ActiveRecordException(e);
                }
                catch (Throwable throwable) {
                    config.close(statement, conn);
                    throw throwable;
                }
            }
            try {
                if (DbKit.isSaveDblog() && CharKit.isNotNull(DbKit.logTableName) && !table.getName().contains(DbKit.logTableName)) {
                    new LogModel().setHeads(sql.toString()).setReturned(result + "").setParams(ToolKit.listToJson(paras)).setType(1).setCode(table.getName()).save();
                }
            }
            catch (Exception e) {
                SysKit.print(e, "\u65e5\u5fd7\u8bb0\u5f55-\u521b\u5efa\u51fa\u95ee\u9898\u4e86");
            }
            return result >= 1;
        }
        catch (ActiveRecordException e) {
            if (e.toString().contains("Key (id)=")) {
                SysKit.print("postgres\u81ea\u589e\u4e3b\u952e\u5f02\u5e38.\u91cd\u65b0\u8bbe\u5b9a\u4e3b\u952e.\u5982\u4f9d\u65e7\u62a5\u9519,\u8bf7\u624b\u52a8\u4fee\u590d");
                this.find("select setval('" + this._getTable().getName() + "_id_seq', max(id)) from " + this._getTable().getName());
                return this.save();
            }
            SysKit.print(e);
            return false;
        }
    }

    public boolean delete() {
        Table table = this._getTable();
        String[] pKeys = table.getPrimaryKey();
        if (pKeys.length == 1) {
            Object id = this.attrs.get(pKeys[0]);
            if (id == null) {
                throw new ActiveRecordException("Primary key " + pKeys[0] + " can not be null");
            }
            return this.deleteById(table, id);
        }
        Object[] ids = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            ids[i] = this.attrs.get(pKeys[i]);
            if (ids[i] != null) continue;
            throw new ActiveRecordException("Primary key " + pKeys[i] + " can not be null");
        }
        return this.deleteById(table, ids);
    }

    public boolean deleteById(Object idValue) {
        if (idValue == null) {
            throw new IllegalArgumentException("idValue can not be null");
        }
        return this.deleteById(this._getTable(), idValue);
    }

    public boolean deleteByIds(Object ... idValues) {
        Table table = this._getTable();
        if (idValues == null || idValues.length != table.getPrimaryKey().length) {
            throw new IllegalArgumentException("Primary key nubmer must equals id value number and can not be null");
        }
        return this.deleteById(table, idValues);
    }

    private boolean deleteById(Table table, Object ... idValues) {
        String sql;
        Config config = this._getConfig();
        Connection conn = null;
        int result = 0;
        try {
            conn = config.getConnection();
            sql = config.dialect.forModelDeleteById(table);
            result = Db.update(config, conn, sql, idValues);
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
        try {
            if (DbKit.isSaveDblog() && CharKit.isNotNull(DbKit.logTableName) && !table.getName().contains(DbKit.logTableName)) {
                new LogModel().setHeads(String.valueOf(sql)).setReturned(result + "").setParams(ToolKit.listToJson(Arrays.asList(idValues))).setType(3).setCode(table.getName()).save();
            }
        }
        catch (Exception e) {
            SysKit.print(e, "\u65e5\u5fd7\u8bb0\u5f55-\u66f4\u65b0\u51fa\u95ee\u9898\u4e86");
        }
        return result >= 1;
    }

    public boolean update() {
        try {
            this.filter(1);
            if (this._getModifyFlag().isEmpty()) {
                return false;
            }
            Table table = this._getTable();
            String[] pKeys = table.getPrimaryKey();
            for (String pKey : pKeys) {
                Object id = this.attrs.get(pKey);
                if (id != null) continue;
                throw new ActiveRecordException(pKey + " \u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            for (Map.Entry entry : this.attrs.entrySet()) {
                if (entry.getValue() == null) continue;
                if (table.getColumnType((String)entry.getKey()) == Long.class) {
                    entry.setValue(Long.parseLong(String.valueOf(entry.getValue())));
                    continue;
                }
                if (table.getColumnType((String)entry.getKey()) == Integer.class) {
                    entry.setValue(Integer.parseInt(String.valueOf(entry.getValue())));
                    continue;
                }
                if (table.getColumnType((String)entry.getKey()) != Timestamp.class) continue;
                if (((String)entry.getKey()).equals("modify_time")) {
                    entry.setValue(new Timestamp(Calendar.getInstance().getTime().getTime()));
                    continue;
                }
                entry.setValue(DateKit.string2Timestamp(entry.getValue().toString()));
            }
            Config config = this._getConfig();
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<Object> paras = new ArrayList<Object>();
            config.dialect.forModelUpdate(table, this.attrs, this._getModifyFlag(), stringBuilder, paras);
            if (paras.size() <= 1) {
                return false;
            }
            Connection conn = null;
            int result = 0;
            try {
                conn = config.getConnection();
                result = Db.update(config, conn, stringBuilder.toString(), paras.toArray());
            }
            catch (Exception e) {
                throw new ActiveRecordException(e);
            }
            finally {
                config.close(conn);
            }
            try {
                if (DbKit.isSaveDblog() && CharKit.isNotNull(DbKit.logTableName) && !table.getName().contains(DbKit.logTableName)) {
                    new LogModel().setHeads(stringBuilder.toString()).setReturned(result + "").setParams(ToolKit.listToJson(paras)).setType(2).setCode(table.getName()).save();
                }
            }
            catch (Exception e) {
                SysKit.print(e, "\u65e5\u5fd7\u8bb0\u5f55-\u66f4\u65b0\u51fa\u95ee\u9898\u4e86");
            }
            if (result >= 1) {
                this._getModifyFlag().clear();
                return true;
            }
            return false;
        }
        catch (ActiveRecordException e) {
            if (e.toString().contains("Key (id)=")) {
                this.find("select setval('" + this._getTable().getName() + "_id_seq', max(id)) from " + this._getTable().getName());
                return this.update();
            }
            return false;
        }
    }

    private List<M> find(Config config, Connection conn, String sql, Object ... paras) throws Exception {
        PreparedStatement pst = conn.prepareStatement(sql);
        config.dialect.fillStatement(pst, paras);
        ResultSet rs = pst.executeQuery();
        List result = config.dialect.buildModelList(rs, this._getUsefulClass());
        DbConfig.close(rs, pst);
        return result;
    }

    protected List<M> find(Config config, String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = config.getConnection();
            List<M> list = this.find(config, conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    public List<M> find(String sql, Object ... paras) {
        return this.find(this._getConfig(), sql, paras);
    }

    public List<M> find(String sql) {
        return this.find(sql, DbConfig.NULL_PARA_ARRAY);
    }

    public List<M> findAll() {
        Config config = this._getConfig();
        String sql = config.dialect.forFindAll(this._getTable().getName());
        return this.find(config, sql, DbConfig.NULL_PARA_ARRAY);
    }

    public M findFirst(String sql, Object ... paras) {
        List<M> result = this.find(sql, paras);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M findFirst(String sql) {
        return this.findFirst(sql, DbConfig.NULL_PARA_ARRAY);
    }

    public M findById(Object idValue) {
        return this.findByIdLoadColumns(new Object[]{idValue}, "*");
    }

    public M findByIds(Object ... idValues) {
        return this.findByIdLoadColumns(idValues, "*");
    }

    public M findByIdLoadColumns(Object idValue, String columns) {
        return this.findByIdLoadColumns(new Object[]{idValue}, columns);
    }

    public M findByIdLoadColumns(Object[] idValues, String columns) {
        String sql;
        Table table = this._getTable();
        if (table.getPrimaryKey().length != idValues.length) {
            throw new IllegalArgumentException("id values error, need " + table.getPrimaryKey().length + " id value");
        }
        Config config = this._getConfig();
        List<M> result = this.find(config, sql = config.dialect.forModelFindById(table, columns), idValues);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M remove(String attr) {
        this.attrs.remove(attr);
        this._getModifyFlag().remove(attr);
        return (M)this;
    }

    public M remove(String ... attrs) {
        if (attrs != null) {
            for (String a : attrs) {
                this.attrs.remove(a);
                this._getModifyFlag().remove(a);
            }
        }
        return (M)this;
    }

    public M removeNullValueAttrs() {
        Iterator<Map.Entry<String, Object>> it = this.attrs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getValue() != null) continue;
            it.remove();
            this._getModifyFlag().remove(e.getKey());
        }
        return (M)this;
    }

    public M keep(String ... attrs) {
        if (attrs != null && attrs.length > 0) {
            Config config = this._getConfig();
            if (config == null) {
                config = DbConfig.brokenConfig;
            }
            Map newAttrs = config.containerFactory.getAttrsMap();
            Set newModifyFlag = config.containerFactory.getModifyFlagSet();
            for (String a : attrs) {
                if (this.attrs.containsKey(a)) {
                    newAttrs.put(a, this.attrs.get(a));
                }
                if (!this._getModifyFlag().contains(a)) continue;
                newModifyFlag.add(a);
            }
            this.attrs = newAttrs;
            this.modifyFlag = newModifyFlag;
        } else {
            this.attrs.clear();
            this._getModifyFlag().clear();
        }
        return (M)this;
    }

    public M keep(String attr) {
        if (this.attrs.containsKey(attr)) {
            Object keepIt = this.attrs.get(attr);
            boolean keepFlag = this._getModifyFlag().contains(attr);
            this.attrs.clear();
            this._getModifyFlag().clear();
            this.attrs.put(attr, keepIt);
            if (keepFlag) {
                this._getModifyFlag().add(attr);
            }
        } else {
            this.attrs.clear();
            this._getModifyFlag().clear();
        }
        return (M)this;
    }

    public M clear() {
        this.attrs.clear();
        this._getModifyFlag().clear();
        return (M)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> e : this.attrs.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = e.getValue();
            if (value != null) {
                value = value.toString();
            }
            sb.append(e.getKey()).append(':').append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Model)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Model mo = (Model)o;
        if (this.getClass() != mo.getClass()) {
            return false;
        }
        return this.attrs.equals(mo.attrs);
    }

    public int hashCode() {
        return this.attrs.hashCode();
    }

    public List<M> findByCache(String cacheName, Object key, String sql, Object ... paras) {
        Config config = this._getConfig();
        ICache cache = config.getCache();
        List<M> result = (List<M>)cache.get(cacheName, key);
        if (result == null) {
            result = this.find(config, sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public List<M> findByCache(String cacheName, Object key, String sql) {
        return this.findByCache(cacheName, key, sql, DbConfig.NULL_PARA_ARRAY);
    }

    public M findFirstByCache(String cacheName, Object key, String sql, Object ... paras) {
        ICache cache = this._getConfig().getCache();
        Model<M> result = (Model)cache.get(cacheName, key);
        if (result == null) {
            result = this.findFirst(sql, paras);
            cache.put(cacheName, key, result);
        }
        return (M)result;
    }

    public M findFirstByCache(String cacheName, Object key, String sql) {
        return this.findFirstByCache(cacheName, key, sql, DbConfig.NULL_PARA_ARRAY);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, DbConfig.NULL_PARA_ARRAY);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    private Page<M> doPaginateByCache(String cacheName, Object key, int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        ICache cache = this._getConfig().getCache();
        Page<M> result = (Page<M>)cache.get(cacheName, key);
        if (result == null) {
            result = this.doPaginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public String toJson() {
        return new Gson().toJson(this.attrs);
    }

    public String getSql(String key) {
        return this._getConfig().getSqlKit().getSql(key);
    }

    public SqlPara getSqlPara(String key, Model model) {
        return this.getSqlPara(key, model.attrs);
    }

    public SqlPara getSqlPara(String key, Map data) {
        return this._getConfig().getSqlKit().getSqlPara(key, data);
    }

    public SqlPara getSqlPara(String key, Object ... paras) {
        return this._getConfig().getSqlKit().getSqlPara(key, paras);
    }

    public List<M> find(SqlPara sqlPara) {
        return this.find(sqlPara.getSql(), sqlPara.getPara());
    }

    public M findFirst(SqlPara sqlPara) {
        return this.findFirst(sqlPara.getSql(), sqlPara.getPara());
    }

    public Page<M> paginate(int pageNumber, int pageSize, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        return this.doPaginate(pageNumber, pageSize, null, sqls[0], sqls[1], sqlPara.getPara());
    }

    public String[] getField() {
        return this.getFields().toArray(new String[0]);
    }

    public List<String> getFields() {
        return new ArrayList<String>(this.getTable().getColumnTypeMap().keySet());
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Model<M> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public List<M> findBy(Map<String, String> map) {
        String keys = "";
        String values = "";
        for (Map.Entry<String, String> set : map.entrySet()) {
            if (set.getValue().equals("undefined")) continue;
            keys = keys + set.getKey() + ",";
            values = values + set.getValue() + ",";
        }
        if (keys.endsWith(",")) {
            keys = keys.substring(0, keys.length() - 1);
            values = values.substring(0, values.length() - 1);
            return this.findBy(keys, values);
        }
        return null;
    }

    public M findByFirst(Map<String, String> map) {
        String keys = "";
        String values = "";
        for (Map.Entry<String, String> set : map.entrySet()) {
            if (set.getValue().equals("undefined")) continue;
            keys = keys + set.getKey() + ",";
            values = values + set.getValue() + ",";
        }
        if (keys.endsWith(",")) {
            keys = keys.substring(0, keys.length() - 1);
            values = values.substring(0, values.length() - 1);
            return this.findByFirst(keys, values);
        }
        return null;
    }

    public List<M> findBy(String key, String value) {
        return this.findBy(key, value, true);
    }

    public List<M> findBy(String key, String value, boolean isDesc) {
        Table table = this.getTable();
        if (key == null || value == null) {
            return null;
        }
        String[] values = value.split(",");
        String[] keys = key.split(",");
        int page = 1;
        int limit = 1000;
        StringBuilder sql = new StringBuilder("select * from " + table.getName() + " where ");
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].equals("page")) {
                page = Integer.parseInt(values[i]);
                continue;
            }
            if (keys[i].equals("limit")) {
                limit = Integer.parseInt(values[i]);
                continue;
            }
            if (i < keys.length - 1 && table.getColumnTypeMap().containsKey(keys[i])) {
                sql.append(keys[i]).append(" = '").append(values[i]).append("' and ");
                continue;
            }
            if (!table.getColumnTypeMap().containsKey(keys[i])) continue;
            sql.append(keys[i]).append(" = '").append(values[i]).append("' ");
        }
        if (sql.toString().endsWith("and ")) {
            sql.delete(sql.length() - 4, sql.length());
        }
        String order = isDesc ? "order by id desc" : "order by id ";
        sql.append(order);
        List<M> result = null;
        try {
            result = this.find(sql.toString());
        }
        catch (Exception e) {
            result = this.find(sql.toString().replace(order, ""));
        }
        return result.size() > 0 ? result : null;
    }

    public M findByFirst(String key, String value) {
        List<M> result = this.findBy(key, value);
        if (result != null && result.size() > 0) {
            return (M)((Model)result.get(0));
        }
        return null;
    }

    public List<M> findValue(String value, int limit, int page) {
        Table table = this.getTable();
        ArrayList<String> keys = new ArrayList<String>(table.getColumnTypeMap().keySet());
        StringBuilder sql = new StringBuilder("select * from " + table.getName() + " where ");
        for (int i = 0; i < keys.size(); ++i) {
            if (i < keys.size() - 1) {
                sql.append((String)keys.get(i)).append(" = '").append(value).append("' and ");
                continue;
            }
            sql.append((String)keys.get(i)).append(" = '").append(value).append("' ");
        }
        String order = "order by id desc";
        sql.append(order);
        List<M> result = null;
        try {
            result = this.find(sql.toString());
        }
        catch (Exception e) {
            result = this.find(sql.toString().replace(order, ""));
        }
        return result.size() > 0 ? result : null;
    }

    public List<M> findOneKey(String key, String ... values) {
        Table table = this.getTable();
        String sql = "select * from " + table.getName() + " where " + key + " in (";
        for (String str : values) {
            sql = sql + "'" + str + "',";
        }
        sql = sql.substring(0, sql.length() - 1);
        sql = sql + ")";
        List<Object> result = new ArrayList();
        try {
            result = this.find(sql);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.size() > 0 ? result : null;
    }

    public Page<M> find() {
        return this.findByKeys(null, null, 1, this.pageSize);
    }

    public Page<M> find(int pageNum) {
        return this.findByKeys(null, null, pageNum, this.pageSize);
    }

    public Page<M> find(int pageNum, int pageSize) {
        this.setPageSize(pageSize);
        return this.findByKeys(null, null, pageNum, pageSize);
    }

    public Page<M> find(final String key, final Object value) {
        return this.findByKeys((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(key, value);
            }
        }, null, 1, this.pageSize);
    }

    public Page<M> find(final String key, final Object value, int pageNum, int pageSize) {
        return this.findByKeys((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(key, value);
            }
        }, null, pageNum, pageSize);
    }

    public Page<M> findNews(final String key, final Object value) {
        return this.findByKeys((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(key, value);
            }
        }, (Map<String, Boolean>)new HashMap<String, Boolean>(){
            {
                this.put("id", false);
            }
        }, 1, this.pageSize);
    }

    public Page<M> findNews(final String key, final Object value, int pageNum) {
        return this.findByKeys((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(key, value);
            }
        }, (Map<String, Boolean>)new HashMap<String, Boolean>(){
            {
                this.put("id", false);
            }
        }, pageNum, this.pageSize);
    }

    public Page<M> findNews(final String key, final Object value, int pageNum, int pageSize) {
        return this.findByKeys((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(key, value);
            }
        }, (Map<String, Boolean>)new HashMap<String, Boolean>(){
            {
                this.put("id", false);
            }
        }, pageNum, pageSize);
    }

    public Page<M> findByKeys(Map<String, Object> kv, Map<String, Boolean> orderBys, int pageNum, int pageSize) {
        Table table = this.getTable();
        String sql = " from " + table.getName() + " ";
        String orderStr = " order by ";
        String whereStr = " where ";
        if (null != kv) {
            for (Map.Entry<String, Object> entry : kv.entrySet()) {
                if (null == entry.getKey()) continue;
                if (entry.getKey().endsWith("_time") || entry.getKey().endsWith("_date")) {
                    if (entry.getValue() instanceof List && ((List)entry.getValue()).size() >= 2) {
                        if (((List)entry.getValue()).size() == 3) {
                            whereStr = whereStr + " " + entry.getKey() + " not between  '" + ((List)entry.getValue()).get(0) + "' and '" + ((List)entry.getValue()).get(1) + "' and";
                            continue;
                        }
                        whereStr = whereStr + " " + entry.getKey() + " between  '" + ((List)entry.getValue()).get(0) + "' and '" + ((List)entry.getValue()).get(1) + "' and";
                        continue;
                    }
                    if (!(entry.getValue() instanceof String) || !entry.getValue().toString().contains(",")) continue;
                    String[] vls = entry.getValue().toString().split(",");
                    if (vls.length == 2) {
                        whereStr = whereStr + " " + entry.getKey() + " between  '" + vls[0] + "' and '" + vls[1] + "' and";
                        continue;
                    }
                    if (vls.length != 3) continue;
                    whereStr = whereStr + " " + entry.getKey() + " not between  '" + vls[0] + "' and '" + vls[1] + "' and";
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    String tempIn = " " + entry.getKey() + " in (";
                    for (Object obj : (List)entry.getValue()) {
                        tempIn = tempIn + "'" + obj + "',";
                    }
                    if (tempIn.endsWith(",")) {
                        tempIn = tempIn.substring(0, tempIn.length() - 1);
                    }
                    if (null == (tempIn = tempIn.endsWith("(") ? null : tempIn + ") and")) continue;
                    whereStr = whereStr + tempIn;
                    continue;
                }
                whereStr = whereStr + " " + entry.getKey() + " = '" + entry.getValue() + "' and";
            }
        } else {
            whereStr = " ";
        }
        if (whereStr.endsWith("and")) {
            whereStr = whereStr.substring(0, whereStr.length() - 3);
        }
        if (whereStr.length() > 10) {
            sql = sql + whereStr + " ";
        }
        if (null != orderBys) {
            for (Map.Entry<String, Object> entry : orderBys.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) {
                    orderStr = orderStr + entry.getKey() + " asc ,";
                    continue;
                }
                orderStr = orderStr + entry.getKey() + " desc ,";
            }
        } else {
            orderStr = orderStr + " id asc  ";
        }
        if (orderStr.endsWith(",")) {
            orderStr = CharKit.catTail(orderStr);
        }
        if (orderStr.length() > 13) {
            sql = sql + orderStr + " ";
        }
        return this.paginate(pageNum, pageSize, "select *", sql);
    }

    @Deprecated
    public boolean delBy(String key, String ... values) {
        if (values.length == 0) {
            return false;
        }
        Table table = this.getTable();
        String sql = "delete  from " + table.getName() + " where " + key;
        if (values.length == 1) {
            sql = sql + " = '" + values[0] + "'";
        } else {
            StringBuilder inVl = new StringBuilder();
            for (String v : values) {
                inVl.append("'").append(v).append("',");
            }
            inVl = new StringBuilder(inVl.substring(0, inVl.length() - 1));
            sql = sql + "in (" + inVl + ")";
        }
        int result = 0;
        try {
            result = Db.update(sql);
        }
        catch (Exception e) {
            SysKit.print(e, "delby");
        }
        return result > -1;
    }

    public List<M> findBy(String key, String value, boolean isAsc, String orderKey) {
        List<M> result;
        Table table = this.getTable();
        StringBuilder sql = new StringBuilder("select * from " + table.getName() + " ");
        if (value != null && value.length() != 0) {
            sql.append(" where ");
            String[] keys = key.split(",");
            String[] values = value.split(",");
            for (int i = 0; i < keys.length; ++i) {
                if (i == keys.length - 1) {
                    sql.append(keys[i]).append(" = '").append(values[i]).append("' ");
                    continue;
                }
                sql.append(keys[i]).append(" = '").append(values[i]).append("' and ");
            }
        }
        if (orderKey != null) {
            if (isAsc) {
                sql.append("order by ").append(orderKey).append(" asc");
            } else {
                sql.append("order by ").append(orderKey).append(" desc");
            }
        }
        return (result = this.find(sql.toString())).size() > 0 ? result : null;
    }

    public boolean saveOrUpdate() {
        try {
            if (this._getAttrs().get("id") != null && this._getAttrs().get("id").toString().length() > 0) {
                this._getAttrs().put("id", Long.parseLong(String.valueOf(this._getAttrs().get("id"))));
                return this.update();
            }
            return this.save();
        }
        catch (Exception e) {
            if (e.toString().contains("Key (id)=")) {
                SysKit.print("postgres\u81ea\u589e\u4e3b\u952e\u5f02\u5e38.\u91cd\u65b0\u8bbe\u5b9a\u4e3b\u952e.\u5982\u4f9d\u65e7\u62a5\u9519,\u8bf7\u624b\u52a8\u4fee\u590d");
                this.find("select setval('" + this.getTableName() + "_id_seq', max(id)) from " + this.getTableName());
                if (this._getAttrs().get("id") != null) {
                    this._getAttrs().put("id", Long.parseLong(String.valueOf(this._getAttrs().get("id"))));
                    return this.update();
                }
                return this.save();
            }
            SysKit.print(e);
            return false;
        }
    }

    public M findFirstBy(String key, String value) {
        try {
            Table table = this.getTable();
            String[] keys = key.split(",");
            String[] values = value.split(",");
            String sql = "select * from " + table.getName() + " where ";
            for (int i = 0; i < keys.length; ++i) {
                sql = i == keys.length - 1 ? sql + keys[i] + " = '" + values[i] + "' " : sql + keys[i] + " = '" + values[i] + "' and ";
            }
            List<M> result = this.find(sql);
            return (M)(result.size() > 0 ? (Model)result.get(0) : null);
        }
        catch (Exception e) {
            SysKit.print(e);
            return null;
        }
    }

    public List<M> getAll() {
        return this.getAllSort("id ");
    }

    public List<M> getAllSort(String sort) {
        Table table = this.getTable();
        List<M> result = this.find("select * from  " + table.getName() + " order by   " + sort + " ");
        return result.size() > 0 ? result : null;
    }

    public Table getTable() {
        return TableMapping.me().getTable(this.getUsefulClass());
    }

    private Class<? extends Model> getUsefulClass() {
        Class<?> c = this.getClass();
        return !c.getName().contains("EnhancerByCGLIB") ? c : c.getSuperclass();
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public long id() {
        return this.getLong("id");
    }

    public String code() {
        return this.getStr("code");
    }

    public String name() {
        return this.getStr("name");
    }

    public String creator() {
        return this.getStr("creator");
    }

    public String mender() {
        return this.getStr("mender");
    }

    public Integer is_del() {
        return this.getInt("is_del");
    }

    public String create_Time() {
        return this.getStr("create_time");
    }

    public String modify_time() {
        return this.getStr("modify_time");
    }

    public long getId() {
        this.id = this.getLong("id");
        return this.id;
    }

    public String getCode() {
        this.code = this.getStr("code");
        return this.code;
    }

    public Model<M> setCode(String v) {
        this.code = v;
        this.set("code", v);
        return this;
    }

    public String getName() {
        this.name = this.getStr("name");
        return this.name;
    }

    public Model<M> setName(String v) {
        this.name = v;
        this.set("name", v);
        return this;
    }

    public String getCreator() {
        this.creator = this.getStr("creator");
        return this.creator;
    }

    public Model<M> setCreator(String v) {
        this.creator = v;
        this.set("creator", v);
        return this;
    }

    public String getMender() {
        this.mender = (String)this.get("mender");
        return this.mender;
    }

    public Model<M> setMender(String mender) {
        this.mender = mender;
        this.set("mender", mender);
        return this;
    }

    public Date getCreateTime() {
        this.create_time = this.getDate("create_time");
        return this.create_time;
    }

    public Model<M> setCreateTime(Date createTime) {
        this.create_time = createTime;
        this.set("create_time", createTime);
        return this;
    }

    public Date getModifyTime() {
        this.modify_time = (Date)this.get("modify_time");
        return this.modify_time;
    }

    public Model<M> setModifyTime(Date modifyTime) {
        this.modify_time = modifyTime;
        this.set("modify_time", modifyTime);
        return this;
    }

    public boolean isDel() {
        this.is_del = this.getStr("is_del").equals("1");
        return this.is_del;
    }

    public Model<M> setDel(boolean isDel) {
        this.is_del = isDel;
        this.set("is_del", isDel ? 1 : 0);
        return this;
    }

    public boolean hasValue(String val) {
        for (Object v : this._getAttrValues()) {
            if (!String.valueOf(v).contains(val)) continue;
            return true;
        }
        return false;
    }
}

