/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.plugin.activerecord.generator;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import space.yizhu.kits.StrKit;
import space.yizhu.record.plugin.activerecord.dialect.Dialect;
import space.yizhu.record.plugin.activerecord.dialect.MysqlDialect;
import space.yizhu.record.plugin.activerecord.dialect.OracleDialect;
import space.yizhu.record.plugin.activerecord.generator.ColumnMeta;
import space.yizhu.record.plugin.activerecord.generator.TableMeta;
import space.yizhu.record.plugin.activerecord.generator.TypeMapping;

public class MetaBuilder {
    protected DataSource dataSource;
    protected Dialect dialect = new MysqlDialect();
    protected Set<String> excludedTables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected Connection conn = null;
    protected DatabaseMetaData dbMeta = null;
    protected String[] removedTableNamePrefixes = null;
    protected TypeMapping typeMapping = new TypeMapping();
    protected boolean generateRemarks = false;

    public MetaBuilder(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        this.dataSource = dataSource;
    }

    public void setGenerateRemarks(boolean generateRemarks) {
        this.generateRemarks = generateRemarks;
    }

    public void setDialect(Dialect dialect) {
        if (dialect != null) {
            this.dialect = dialect;
        }
    }

    public void addExcludedTable(String ... excludedTables) {
        if (excludedTables != null) {
            for (String table : excludedTables) {
                this.excludedTables.add(table);
            }
        }
    }

    public void setRemovedTableNamePrefixes(String ... removedTableNamePrefixes) {
        this.removedTableNamePrefixes = removedTableNamePrefixes;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        if (typeMapping != null) {
            this.typeMapping = typeMapping;
        }
    }

    public List<TableMeta> build() {
        System.out.println("Build TableMeta ...");
        try {
            this.conn = this.dataSource.getConnection();
            this.dbMeta = this.conn.getMetaData();
            ArrayList<TableMeta> ret = new ArrayList<TableMeta>();
            this.buildTableNames(ret);
            for (TableMeta tableMeta : ret) {
                this.buildPrimaryKey(tableMeta);
                this.buildColumnMetas(tableMeta);
            }
            this.removeNoPrimaryKeyTable(ret);
            ArrayList<TableMeta> arrayList = ret;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void removeNoPrimaryKeyTable(List<TableMeta> ret) {
        Iterator<TableMeta> it = ret.iterator();
        while (it.hasNext()) {
            TableMeta tm = it.next();
            if (!StrKit.isBlank(tm.primaryKey)) continue;
            it.remove();
            System.err.println("Skip table " + tm.name + " because there is no primary key");
        }
    }

    protected boolean isSkipTable(String tableName) {
        return false;
    }

    protected String buildModelName(String tableName) {
        if (this.removedTableNamePrefixes != null) {
            for (String prefix : this.removedTableNamePrefixes) {
                if (!tableName.startsWith(prefix)) continue;
                tableName = tableName.replaceFirst(prefix, "");
                break;
            }
        }
        if (this.dialect instanceof OracleDialect) {
            tableName = tableName.toLowerCase();
        }
        return StrKit.firstCharToUpperCase(StrKit.toCamelCase(tableName));
    }

    protected String buildBaseModelName(String modelName) {
        return "Base" + modelName;
    }

    protected ResultSet getTablesResultSet() throws SQLException {
        String schemaPattern = this.dialect instanceof OracleDialect ? this.dbMeta.getUserName() : null;
        return this.dbMeta.getTables(this.conn.getCatalog(), schemaPattern, null, new String[]{"TABLE"});
    }

    protected void buildTableNames(List<TableMeta> ret) throws SQLException {
        ResultSet rs = this.getTablesResultSet();
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            if (this.excludedTables.contains(tableName)) {
                System.out.println("Skip table :" + tableName);
                continue;
            }
            if (this.isSkipTable(tableName)) {
                System.out.println("Skip table :" + tableName);
                continue;
            }
            TableMeta tableMeta = new TableMeta();
            tableMeta.name = tableName;
            tableMeta.remarks = rs.getString("REMARKS");
            tableMeta.modelName = this.buildModelName(tableName);
            tableMeta.baseModelName = this.buildBaseModelName(tableMeta.modelName);
            ret.add(tableMeta);
        }
        rs.close();
    }

    protected void buildPrimaryKey(TableMeta tableMeta) throws SQLException {
        ResultSet rs = this.dbMeta.getPrimaryKeys(this.conn.getCatalog(), null, tableMeta.name);
        String primaryKey = "";
        int index = 0;
        while (rs.next()) {
            if (index++ > 0) {
                primaryKey = primaryKey + ",";
            }
            primaryKey = primaryKey + rs.getString("COLUMN_NAME");
        }
        tableMeta.primaryKey = primaryKey;
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildColumnMetas(TableMeta tableMeta) throws SQLException {
        String sql = this.dialect.forTableBuilderDoBuild(tableMeta.name);
        Statement stm = this.conn.createStatement();
        ResultSet rs = stm.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        HashMap<String, ColumnMeta> columnMetaMap = new HashMap<String, ColumnMeta>();
        if (this.generateRemarks) {
            DatabaseMetaData dbMeta = this.conn.getMetaData();
            try (ResultSet colMetaRs = null;){
                colMetaRs = dbMeta.getColumns(null, null, tableMeta.name, null);
                while (colMetaRs.next()) {
                    ColumnMeta columnMeta = new ColumnMeta();
                    columnMeta.name = colMetaRs.getString("COLUMN_NAME");
                    columnMeta.remarks = colMetaRs.getString("REMARKS");
                    columnMetaMap.put(columnMeta.name, columnMeta);
                }
            }
        }
        for (int i = 1; i <= columnCount; ++i) {
            ColumnMeta cm = new ColumnMeta();
            cm.name = rsmd.getColumnName(i);
            String typeStr = null;
            if (this.dialect.isKeepByteAndShort()) {
                int type = rsmd.getColumnType(i);
                if (type == -6) {
                    typeStr = "java.lang.Byte";
                } else if (type == 5) {
                    typeStr = "java.lang.Short";
                }
            }
            if (typeStr == null) {
                String colClassName = rsmd.getColumnClassName(i);
                typeStr = this.typeMapping.getType(colClassName);
            }
            if (typeStr == null) {
                int type = rsmd.getColumnType(i);
                typeStr = type == -2 || type == -3 || type == -4 || type == 2004 ? "byte[]" : (type == 2005 || type == 2011 ? "java.lang.String" : (type == 93 || type == 91 ? "java.util.Date" : (type == 1111 ? "java.lang.Object" : "java.lang.String")));
            }
            cm.javaType = typeStr = this.handleJavaType(typeStr, rsmd, i);
            cm.attrName = this.buildAttrName(cm.name);
            if (this.generateRemarks && columnMetaMap.containsKey(cm.name)) {
                cm.remarks = ((ColumnMeta)columnMetaMap.get((Object)cm.name)).remarks;
            }
            tableMeta.columnMetas.add(cm);
        }
        rs.close();
        stm.close();
    }

    protected String handleJavaType(String typeStr, ResultSetMetaData rsmd, int column) throws SQLException {
        if (!this.dialect.isOracle()) {
            return typeStr;
        }
        if ("java.math.BigDecimal".equals(typeStr)) {
            int scale = rsmd.getScale(column);
            int precision = rsmd.getPrecision(column);
            typeStr = scale == 0 ? (precision <= 9 ? "java.lang.Integer" : (precision <= 18 ? "java.lang.Long" : "java.math.BigDecimal")) : "java.math.BigDecimal";
        }
        return typeStr;
    }

    protected String buildAttrName(String colName) {
        if (this.dialect instanceof OracleDialect) {
            colName = colName.toLowerCase();
        }
        return StrKit.toCamelCase(colName);
    }
}

