/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.plugin.activerecord.sql;

import java.util.Map;
import space.yizhu.kits.StrKit;
import space.yizhu.record.template.Directive;
import space.yizhu.record.template.Env;
import space.yizhu.record.template.Template;
import space.yizhu.record.template.expr.ast.Const;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;

public class SqlDirective
extends Directive {
    private String id;

    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #sql directive can not be blank", this.location);
        }
        if (exprList.length() > 1) {
            throw new ParseException("Only one parameter allowed for #sql directive", this.location);
        }
        Expr expr = exprList.getExpr(0);
        if (!(expr instanceof Const) || !((Const)expr).isStr()) {
            throw new ParseException("The parameter of #sql directive must be String", this.location);
        }
        this.id = ((Const)expr).getStr();
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        String nameSpace = (String)scope.get("_NAME_SPACE_");
        String key = StrKit.isBlank(nameSpace) ? this.id : nameSpace + "." + this.id;
        Map sqlTemplateMap = (Map)scope.get("_SQL_TEMPLATE_MAP_");
        if (sqlTemplateMap.containsKey(key)) {
            throw new ParseException("Sql already exists with key : " + key, this.location);
        }
        sqlTemplateMap.put(key, new Template(env, this.stat));
    }

    @Override
    public boolean hasEnd() {
        return true;
    }
}

