/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import space.yizhu.kits.StrKit;
import space.yizhu.record.template.Directive;
import space.yizhu.record.template.Env;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.expr.ast.SharedMethodKit;
import space.yizhu.record.template.ext.directive.CallDirective;
import space.yizhu.record.template.ext.directive.DateDirective;
import space.yizhu.record.template.ext.directive.EscapeDirective;
import space.yizhu.record.template.ext.directive.NumberDirective;
import space.yizhu.record.template.ext.directive.RandomDirective;
import space.yizhu.record.template.ext.directive.RenderDirective;
import space.yizhu.record.template.ext.directive.StringDirective;
import space.yizhu.record.template.ext.sharedmethod.SharedMethodLib;
import space.yizhu.record.template.io.EncoderFactory;
import space.yizhu.record.template.io.WriterBuffer;
import space.yizhu.record.template.source.FileSource;
import space.yizhu.record.template.source.FileSourceFactory;
import space.yizhu.record.template.source.ISource;
import space.yizhu.record.template.source.ISourceFactory;
import space.yizhu.record.template.source.StringSource;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.OutputDirectiveFactory;
import space.yizhu.record.template.stat.Parser;
import space.yizhu.record.template.stat.ast.Define;
import space.yizhu.record.template.stat.ast.Output;

public class EngineConfig {
    public static final String DEFAULT_ENCODING = "UTF-8";
    WriterBuffer writerBuffer = new WriterBuffer();
    private Map<String, Define> sharedFunctionMap = this.createSharedFunctionMap();
    private List<ISource> sharedFunctionSourceList = new ArrayList<ISource>();
    Map<String, Object> sharedObjectMap = null;
    private OutputDirectiveFactory outputDirectiveFactory = OutputDirectiveFactory.me;
    private ISourceFactory sourceFactory = new FileSourceFactory();
    private Map<String, Class<? extends Directive>> directiveMap = new HashMap<String, Class<? extends Directive>>(64, 0.5f);
    private SharedMethodKit sharedMethodKit = new SharedMethodKit();
    private boolean devMode = false;
    private boolean reloadModifiedSharedFunctionInDevMode = true;
    private String baseTemplatePath = null;
    private String encoding = "UTF-8";
    private String datePattern = "yyyy-MM-dd HH:mm";

    public EngineConfig() {
        this.addDirective("render", RenderDirective.class);
        this.addDirective("date", DateDirective.class);
        this.addDirective("escape", EscapeDirective.class);
        this.addDirective("string", StringDirective.class);
        this.addDirective("random", RandomDirective.class);
        this.addDirective("number", NumberDirective.class);
        this.addDirective("call", CallDirective.class);
        this.addSharedMethod(new SharedMethodLib());
    }

    public void addSharedFunction(String fileName) {
        fileName = fileName.replace("\\", "/");
        ISource source = this.sourceFactory.getSource(this.baseTemplatePath, fileName, this.encoding);
        this.doAddSharedFunction(source, fileName);
    }

    private synchronized void doAddSharedFunction(ISource source, String fileName) {
        Env env = new Env(this);
        new Parser(env, source.getContent(), fileName).parse();
        this.addToSharedFunctionMap(this.sharedFunctionMap, env);
        if (this.devMode) {
            this.sharedFunctionSourceList.add(source);
            env.addSource(source);
        }
    }

    public void addSharedFunction(String ... fileNames) {
        for (String fileName : fileNames) {
            this.addSharedFunction(fileName);
        }
    }

    public void addSharedFunctionByString(String content) {
        StringSource stringSource = new StringSource(content, false);
        this.doAddSharedFunction(stringSource, null);
    }

    public void addSharedFunction(ISource source) {
        String fileName = source instanceof FileSource ? ((FileSource)source).getFileName() : null;
        this.doAddSharedFunction(source, fileName);
    }

    private void addToSharedFunctionMap(Map<String, Define> sharedFunctionMap, Env env) {
        Map<String, Define> funcMap = env.getFunctionMap();
        for (Map.Entry<String, Define> e : funcMap.entrySet()) {
            if (sharedFunctionMap.containsKey(e.getKey())) {
                throw new IllegalArgumentException("Template function already exists : " + e.getKey());
            }
            Define func = e.getValue();
            if (this.devMode) {
                func.setEnvForDevMode(env);
            }
            sharedFunctionMap.put(e.getKey(), func);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Define getSharedFunction(String functionName) {
        Define func = this.sharedFunctionMap.get(functionName);
        if (func == null) {
            return null;
        }
        if (this.devMode && this.reloadModifiedSharedFunctionInDevMode && func.isSourceModifiedForDevMode()) {
            EngineConfig engineConfig = this;
            synchronized (engineConfig) {
                func = this.sharedFunctionMap.get(functionName);
                if (func.isSourceModifiedForDevMode()) {
                    this.reloadSharedFunctionSourceList();
                    func = this.sharedFunctionMap.get(functionName);
                }
            }
        }
        return func;
    }

    private synchronized void reloadSharedFunctionSourceList() {
        Map<String, Define> newMap = this.createSharedFunctionMap();
        int size = this.sharedFunctionSourceList.size();
        for (int i = 0; i < size; ++i) {
            ISource source = this.sharedFunctionSourceList.get(i);
            String fileName = source instanceof FileSource ? ((FileSource)source).getFileName() : null;
            Env env = new Env(this);
            new Parser(env, source.getContent(), fileName).parse();
            this.addToSharedFunctionMap(newMap, env);
            if (!this.devMode) continue;
            env.addSource(source);
        }
        this.sharedFunctionMap = newMap;
    }

    private Map<String, Define> createSharedFunctionMap() {
        return new HashMap<String, Define>(512, 0.25f);
    }

    public synchronized void addSharedObject(String name, Object object) {
        if (this.sharedObjectMap == null) {
            this.sharedObjectMap = new HashMap<String, Object>(64, 0.25f);
        } else if (this.sharedObjectMap.containsKey(name)) {
            throw new IllegalArgumentException("Shared object already exists: " + name);
        }
        this.sharedObjectMap.put(name, object);
    }

    Map<String, Object> getSharedObjectMap() {
        return this.sharedObjectMap;
    }

    public void setOutputDirectiveFactory(OutputDirectiveFactory outputDirectiveFactory) {
        if (outputDirectiveFactory == null) {
            throw new IllegalArgumentException("outputDirectiveFactory can not be null");
        }
        this.outputDirectiveFactory = outputDirectiveFactory;
    }

    public Output getOutputDirective(ExprList exprList, Location location) {
        return this.outputDirectiveFactory.getOutputDirective(exprList, location);
    }

    void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    void setSourceFactory(ISourceFactory sourceFactory) {
        if (sourceFactory == null) {
            throw new IllegalArgumentException("sourceFactory can not be null");
        }
        this.sourceFactory = sourceFactory;
    }

    public ISourceFactory getSourceFactory() {
        return this.sourceFactory;
    }

    public void setBaseTemplatePath(String baseTemplatePath) {
        if (baseTemplatePath == null) {
            this.baseTemplatePath = null;
            return;
        }
        if (StrKit.isBlank(baseTemplatePath)) {
            throw new IllegalArgumentException("baseTemplatePath can not be blank");
        }
        baseTemplatePath = baseTemplatePath.trim();
        if ((baseTemplatePath = baseTemplatePath.replace("\\", "/")).length() > 1 && baseTemplatePath.endsWith("/")) {
            baseTemplatePath = baseTemplatePath.substring(0, baseTemplatePath.length() - 1);
        }
        this.baseTemplatePath = baseTemplatePath;
    }

    public String getBaseTemplatePath() {
        return this.baseTemplatePath;
    }

    public void setEncoding(String encoding) {
        if (StrKit.isBlank(encoding)) {
            throw new IllegalArgumentException("encoding can not be blank");
        }
        this.encoding = encoding;
        this.writerBuffer.setEncoding(encoding);
    }

    public void setEncoderFactory(EncoderFactory encoderFactory) {
        this.writerBuffer.setEncoderFactory(encoderFactory);
        this.writerBuffer.setEncoding(this.encoding);
    }

    public void setWriterBufferSize(int bufferSize) {
        this.writerBuffer.setBufferSize(bufferSize);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDatePattern(String datePattern) {
        if (StrKit.isBlank(datePattern)) {
            throw new IllegalArgumentException("datePattern can not be blank");
        }
        this.datePattern = datePattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setReloadModifiedSharedFunctionInDevMode(boolean reloadModifiedSharedFunctionInDevMode) {
        this.reloadModifiedSharedFunctionInDevMode = reloadModifiedSharedFunctionInDevMode;
    }

    @Deprecated
    public void addDirective(String directiveName, Directive directive) {
        this.addDirective(directiveName, directive.getClass());
    }

    public synchronized void addDirective(String directiveName, Class<? extends Directive> directiveClass) {
        if (StrKit.isBlank(directiveName)) {
            throw new IllegalArgumentException("directive name can not be blank");
        }
        if (directiveClass == null) {
            throw new IllegalArgumentException("directiveClass can not be null");
        }
        if (this.directiveMap.containsKey(directiveName)) {
            throw new IllegalArgumentException("directive already exists : " + directiveName);
        }
        this.directiveMap.put(directiveName, directiveClass);
    }

    public Class<? extends Directive> getDirective(String directiveName) {
        return this.directiveMap.get(directiveName);
    }

    public void removeDirective(String directiveName) {
        this.directiveMap.remove(directiveName);
    }

    public void addSharedMethod(Object sharedMethodFromObject) {
        this.sharedMethodKit.addSharedMethod(sharedMethodFromObject);
    }

    public void addSharedMethod(Class<?> sharedMethodFromClass) {
        this.sharedMethodKit.addSharedMethod(sharedMethodFromClass);
    }

    public void addSharedStaticMethod(Class<?> sharedStaticMethodFromClass) {
        this.sharedMethodKit.addSharedStaticMethod(sharedStaticMethodFromClass);
    }

    public void removeSharedMethod(String methodName) {
        this.sharedMethodKit.removeSharedMethod(methodName);
    }

    public void removeSharedMethod(Class<?> sharedClass) {
        this.sharedMethodKit.removeSharedMethod(sharedClass);
    }

    public void removeSharedMethod(Method method) {
        this.sharedMethodKit.removeSharedMethod(method);
    }

    public SharedMethodKit getSharedMethodKit() {
        return this.sharedMethodKit;
    }
}

