/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import space.yizhu.record.template.EngineConfig;
import space.yizhu.record.template.source.ISource;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.ast.Define;

public class Env {
    protected EngineConfig engineConfig;
    protected Map<String, Define> functionMap = new HashMap<String, Define>(16, 0.5f);
    protected List<ISource> sourceList = null;

    public Env(EngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public boolean isDevMode() {
        return this.engineConfig.isDevMode();
    }

    public void addFunction(Define function) {
        String fn = function.getFunctionName();
        if (this.functionMap.containsKey(fn)) {
            Define previous = this.functionMap.get(fn);
            throw new ParseException("Template function \"" + fn + "\" already defined in " + this.getAlreadyDefinedLocation(previous.getLocation()), function.getLocation());
        }
        this.functionMap.put(fn, function);
    }

    private String getAlreadyDefinedLocation(Location loc) {
        StringBuilder buf = new StringBuilder();
        if (loc.getTemplateFile() != null) {
            buf.append(loc.getTemplateFile()).append(", line ").append(loc.getRow());
        } else {
            buf.append("string template line ").append(loc.getRow());
        }
        return buf.toString();
    }

    public Define getFunction(String functionName) {
        Define func = this.functionMap.get(functionName);
        return func != null ? func : this.engineConfig.getSharedFunction(functionName);
    }

    Map<String, Define> getFunctionMap() {
        return this.functionMap;
    }

    public boolean isSourceListModified() {
        if (this.sourceList != null) {
            int size = this.sourceList.size();
            for (int i = 0; i < size; ++i) {
                if (!this.sourceList.get(i).isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public void addSource(ISource source) {
        if (this.sourceList == null) {
            this.sourceList = new ArrayList<ISource>();
        }
        this.sourceList.add(source);
    }
}

