/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.expr;

import java.math.BigDecimal;
import space.yizhu.record.template.expr.Sym;
import space.yizhu.record.template.expr.Tok;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;

public class NumTok
extends Tok {
    private Number value;

    NumTok(Sym sym, String s, int radix, boolean isScientificNotation, Location location) {
        super(sym, location.getRow());
        try {
            this.typeConvert(sym, s, radix, isScientificNotation, location);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), location, e);
        }
    }

    private void typeConvert(Sym sym, String s, int radix, boolean isScientificNotation, Location location) {
        switch (sym) {
            case INT: {
                if (isScientificNotation) {
                    this.value = new BigDecimal(s).intValue();
                    break;
                }
                this.value = Integer.valueOf(s, radix);
                break;
            }
            case LONG: {
                if (isScientificNotation) {
                    this.value = new BigDecimal(s).longValue();
                    break;
                }
                this.value = Long.valueOf(s, radix);
                break;
            }
            case FLOAT: {
                if (isScientificNotation) {
                    this.value = Float.valueOf(new BigDecimal(s).floatValue());
                    break;
                }
                this.value = Float.valueOf(s);
                break;
            }
            case DOUBLE: {
                if (isScientificNotation) {
                    this.value = new BigDecimal(s).doubleValue();
                    break;
                }
                this.value = Double.valueOf(s);
                break;
            }
            default: {
                throw new ParseException("Unsupported type: " + sym.value(), location);
            }
        }
    }

    @Override
    public String value() {
        return this.value.toString();
    }

    public Object getNumberValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.sym.value() + " : " + this.value;
    }
}

