/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.expr.ast;

import java.util.ArrayList;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;

public class Array
extends Expr {
    private Expr[] exprList;

    public Array(Expr[] exprList, Location location) {
        if (exprList == null) {
            throw new ParseException("exprList can not be null", location);
        }
        this.exprList = exprList;
    }

    @Override
    public Object eval(Scope scope) {
        ArrayListExt array = new ArrayListExt(this.exprList.length);
        for (Expr expr : this.exprList) {
            array.add(expr.eval(scope));
        }
        return array;
    }

    public static class ArrayListExt
    extends ArrayList<Object> {
        public ArrayListExt(int initialCapacity) {
            super(initialCapacity);
        }

        public Integer getLength() {
            return this.size();
        }
    }
}

