/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.expr.ast;

import java.math.BigDecimal;
import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.expr.Sym;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;

public class Compare
extends Expr {
    private Sym op;
    private Expr left;
    private Expr right;

    public Compare(Sym op, Expr left, Expr right, Location location) {
        if (left == null || right == null) {
            throw new ParseException("The target of \"" + op.value() + "\" operator can not be blank", location);
        }
        this.op = op;
        this.left = left;
        this.right = right;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object leftValue = this.left.eval(scope);
        Object rightValue = this.right.eval(scope);
        switch (this.op) {
            case EQUAL: {
                return this.equal(leftValue, rightValue);
            }
            case NOTEQUAL: {
                return this.equal(leftValue, rightValue) == false;
            }
            case GT: {
                return this.gt(leftValue, rightValue);
            }
            case GE: {
                return this.ge(leftValue, rightValue);
            }
            case LT: {
                return this.lt(leftValue, rightValue);
            }
            case LE: {
                return this.le(leftValue, rightValue);
            }
        }
        String l = leftValue != null ? leftValue.getClass().getSimpleName() : "null";
        String r = rightValue != null ? rightValue.getClass().getSimpleName() : "null";
        throw new TemplateException("Unsupported operation: " + l + " \"" + this.op.value() + "\" " + r, this.location);
    }

    Boolean equal(Object leftValue, Object rightValue) {
        if (leftValue == rightValue) {
            return Boolean.TRUE;
        }
        if (leftValue == null || rightValue == null) {
            return Boolean.FALSE;
        }
        if (leftValue.equals(rightValue)) {
            return Boolean.TRUE;
        }
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number l = (Number)leftValue;
            Number r = (Number)rightValue;
            int maxType = this.getMaxType(l, r);
            switch (maxType) {
                case 0: {
                    return l.intValue() == r.intValue();
                }
                case 1: {
                    return l.longValue() == r.longValue();
                }
                case 2: {
                    return l.floatValue() == r.floatValue();
                }
                case 3: {
                    return l.doubleValue() == r.doubleValue();
                }
                case 4: {
                    BigDecimal[] bd = this.toBigDecimals(l, r);
                    return bd[0].compareTo(bd[1]) == 0;
                }
            }
            throw new TemplateException("Equal comparison support types of int long float double and BigDeciaml", this.location);
        }
        return Boolean.FALSE;
    }

    Boolean gt(Object leftValue, Object rightValue) {
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number l = (Number)leftValue;
            Number r = (Number)rightValue;
            int maxType = this.getMaxType(l, r);
            switch (maxType) {
                case 0: {
                    return l.intValue() > r.intValue();
                }
                case 1: {
                    return l.longValue() > r.longValue();
                }
                case 2: {
                    return l.floatValue() > r.floatValue();
                }
                case 3: {
                    return l.doubleValue() > r.doubleValue();
                }
                case 4: {
                    BigDecimal[] bd = this.toBigDecimals(l, r);
                    return bd[0].compareTo(bd[1]) > 0;
                }
            }
            throw new TemplateException("Unsupported operation: " + l.getClass().getSimpleName() + " \">\" " + r.getClass().getSimpleName(), this.location);
        }
        if (leftValue instanceof Comparable && rightValue != null && leftValue.getClass() == rightValue.getClass()) {
            return ((Comparable)leftValue).compareTo((Comparable)rightValue) > 0;
        }
        return this.checkComparisonValue(leftValue, rightValue);
    }

    Boolean ge(Object leftValue, Object rightValue) {
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number l = (Number)leftValue;
            Number r = (Number)rightValue;
            int maxType = this.getMaxType(l, r);
            switch (maxType) {
                case 0: {
                    return l.intValue() >= r.intValue();
                }
                case 1: {
                    return l.longValue() >= r.longValue();
                }
                case 2: {
                    return l.floatValue() >= r.floatValue();
                }
                case 3: {
                    return l.doubleValue() >= r.doubleValue();
                }
                case 4: {
                    BigDecimal[] bd = this.toBigDecimals(l, r);
                    return bd[0].compareTo(bd[1]) >= 0;
                }
            }
            throw new TemplateException("Unsupported operation: " + l.getClass().getSimpleName() + " \">=\" " + r.getClass().getSimpleName(), this.location);
        }
        if (leftValue instanceof Comparable && rightValue != null && leftValue.getClass() == rightValue.getClass()) {
            return ((Comparable)leftValue).compareTo((Comparable)rightValue) >= 0;
        }
        return this.checkComparisonValue(leftValue, rightValue);
    }

    Boolean lt(Object leftValue, Object rightValue) {
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number l = (Number)leftValue;
            Number r = (Number)rightValue;
            int maxType = this.getMaxType(l, r);
            switch (maxType) {
                case 0: {
                    return l.intValue() < r.intValue();
                }
                case 1: {
                    return l.longValue() < r.longValue();
                }
                case 2: {
                    return l.floatValue() < r.floatValue();
                }
                case 3: {
                    return l.doubleValue() < r.doubleValue();
                }
                case 4: {
                    BigDecimal[] bd = this.toBigDecimals(l, r);
                    return bd[0].compareTo(bd[1]) < 0;
                }
            }
            throw new TemplateException("Unsupported operation: " + l.getClass().getSimpleName() + " \"<\" " + r.getClass().getSimpleName(), this.location);
        }
        if (leftValue instanceof Comparable && rightValue != null && leftValue.getClass() == rightValue.getClass()) {
            return ((Comparable)leftValue).compareTo((Comparable)rightValue) < 0;
        }
        return this.checkComparisonValue(leftValue, rightValue);
    }

    Boolean le(Object leftValue, Object rightValue) {
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number l = (Number)leftValue;
            Number r = (Number)rightValue;
            int maxType = this.getMaxType(l, r);
            switch (maxType) {
                case 0: {
                    return l.intValue() <= r.intValue();
                }
                case 1: {
                    return l.longValue() <= r.longValue();
                }
                case 2: {
                    return l.floatValue() <= r.floatValue();
                }
                case 3: {
                    return l.doubleValue() <= r.doubleValue();
                }
                case 4: {
                    BigDecimal[] bd = this.toBigDecimals(l, r);
                    return bd[0].compareTo(bd[1]) <= 0;
                }
            }
            throw new TemplateException("Unsupported operation: " + l.getClass().getSimpleName() + " \"<=\" " + r.getClass().getSimpleName(), this.location);
        }
        if (leftValue instanceof Comparable && rightValue != null && leftValue.getClass() == rightValue.getClass()) {
            return ((Comparable)leftValue).compareTo((Comparable)rightValue) <= 0;
        }
        return this.checkComparisonValue(leftValue, rightValue);
    }

    private int getMaxType(Number obj1, Number obj2) {
        int t1 = this.getType(obj1);
        if (t1 == 4) {
            return 4;
        }
        int t2 = this.getType(obj2);
        return t1 > t2 ? t1 : t2;
    }

    private int getType(Number obj) {
        if (obj instanceof Integer) {
            return 0;
        }
        if (obj instanceof Long) {
            return 1;
        }
        if (obj instanceof Float) {
            return 2;
        }
        if (obj instanceof Double) {
            return 3;
        }
        if (obj instanceof BigDecimal) {
            return 4;
        }
        if (obj instanceof Short || obj instanceof Byte) {
            return 0;
        }
        throw new TemplateException("Unsupported data type: " + obj.getClass().getName(), this.location);
    }

    BigDecimal[] toBigDecimals(Number left, Number right) {
        BigDecimal[] ret = new BigDecimal[]{left instanceof BigDecimal ? (BigDecimal)left : new BigDecimal(left.toString()), right instanceof BigDecimal ? (BigDecimal)right : new BigDecimal(right.toString())};
        return ret;
    }

    private Boolean checkComparisonValue(Object leftValue, Object rightValue) {
        if (leftValue == null) {
            throw new TemplateException("The operation target on the left side of \"" + this.op.value() + "\" can not be null", this.location);
        }
        if (rightValue == null) {
            throw new TemplateException("The operation target on the right side of \"" + this.op.value() + "\" can not be null", this.location);
        }
        throw new TemplateException("Unsupported operation: " + leftValue.getClass().getSimpleName() + " \"" + this.op.value() + "\" " + rightValue.getClass().getSimpleName(), this.location);
    }
}

