/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.expr.ast;

import space.yizhu.kits.HashKit;
import space.yizhu.kits.StrKit;
import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.expr.ast.FieldGetter;
import space.yizhu.record.template.expr.ast.FieldKeyBuilder;
import space.yizhu.record.template.expr.ast.FieldKit;
import space.yizhu.record.template.expr.ast.Id;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;

public class Field
extends Expr {
    private Expr expr;
    private String fieldName;
    private String getterName;
    private long getterNameHash;

    public Field(Expr expr, String fieldName, Location location) {
        if (expr == null) {
            throw new ParseException("The object for field access can not be null", location);
        }
        this.expr = expr;
        this.fieldName = fieldName;
        this.getterName = "get" + StrKit.firstCharToUpperCase(fieldName);
        this.getterNameHash = HashKit.fnv1a64(this.getterName);
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object target = this.expr.eval(scope);
        if (target == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            if (this.expr instanceof Id) {
                String id = ((Id)this.expr).getId();
                throw new TemplateException("\"" + id + "\" can not be null for accessed by \"" + id + "." + this.fieldName + "\"", this.location);
            }
            throw new TemplateException("Can not accessed by \"" + this.fieldName + "\" field from null target", this.location);
        }
        try {
            Class<?> targetClass = target.getClass();
            Object key = FieldKeyBuilder.instance.getFieldKey(targetClass, this.getterNameHash);
            FieldGetter fieldGetter = FieldKit.getFieldGetter(key, targetClass, this.fieldName);
            if (fieldGetter.notNull()) {
                return fieldGetter.get(target, this.fieldName);
            }
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
        if (scope.getCtrl().isNullSafe()) {
            return null;
        }
        if (this.expr instanceof Id) {
            String id = ((Id)this.expr).getId();
            throw new TemplateException("public field not found: \"" + id + "." + this.fieldName + "\" and public getter method not found: \"" + id + "." + this.getterName + "()\"", this.location);
        }
        throw new TemplateException("public field not found: \"" + this.fieldName + "\" and public getter method not found: \"" + this.getterName + "()\"", this.location);
    }
}

