/*
 * Decompiled with CFR 0.152.
 */
package space.yizhu.record.template.expr.ast;

public abstract class FieldKeyBuilder {
    static FieldKeyBuilder instance = new StrictFieldKeyBuilder();

    public abstract Object getFieldKey(Class<?> var1, long var2);

    public static FieldKeyBuilder getInstance() {
        return instance;
    }

    public static void setToFastFieldKeyBuilder() {
        instance = new FastFieldKeyBuilder();
    }

    public static void setFieldKeyBuilder(FieldKeyBuilder fieldKeyBuilder) {
        if (fieldKeyBuilder == null) {
            throw new IllegalArgumentException("fieldKeyBuilder can not be null");
        }
        instance = fieldKeyBuilder;
    }

    public static class FieldKey {
        final long classHash;
        final long fieldHash;

        public FieldKey(long classHash, long fieldHash) {
            this.classHash = classHash;
            this.fieldHash = fieldHash;
        }

        public int hashCode() {
            return (int)(this.classHash ^ this.fieldHash);
        }

        public boolean equals(Object fieldKey) {
            FieldKey fk = (FieldKey)fieldKey;
            return this.classHash == fk.classHash && this.fieldHash == fk.fieldHash;
        }

        public String toString() {
            return "classHash = " + this.classHash + "\nfieldHash = " + this.fieldHash;
        }
    }

    public static class StrictFieldKeyBuilder
    extends FieldKeyBuilder {
        @Override
        public Object getFieldKey(Class<?> targetClass, long fieldFnv1a64Hash) {
            return new FieldKey(targetClass.getName().hashCode(), fieldFnv1a64Hash);
        }
    }

    public static class FastFieldKeyBuilder
    extends FieldKeyBuilder {
        @Override
        public Object getFieldKey(Class<?> targetClass, long fieldFnv1a64Hash) {
            return (long)targetClass.getName().hashCode() ^ fieldFnv1a64Hash;
        }
    }
}

